package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.LocalTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.DayOfWeek;

@JsonPropertyOrder({
    "@odata.type", 
    "daylightBias"})
@JsonInclude(Include.NON_NULL)
public class DaylightTimeZoneOffset extends StandardTimeZoneOffset implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("daylightBias")
    protected Integer daylightBias;

    protected DaylightTimeZoneOffset() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.daylightTimeZoneOffset";
    }

    @Property(name="daylightBias")
    @JsonIgnore
    public Optional<Integer> getDaylightBias() {
        return Optional.ofNullable(daylightBias);
    }

    public DaylightTimeZoneOffset withDaylightBias(Integer daylightBias) {
        DaylightTimeZoneOffset _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.daylightTimeZoneOffset");
        _x.daylightBias = daylightBias;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDaylightTimeZoneOffset() {
        return new Builder();
    }

    public static final class Builder {
        private LocalTime time;
        private Integer dayOccurrence;
        private DayOfWeek dayOfWeek;
        private Integer month;
        private Integer year;
        private Integer daylightBias;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder time(LocalTime time) {
            this.time = time;
            this.changedFields = changedFields.add("time");
            return this;
        }

        public Builder dayOccurrence(Integer dayOccurrence) {
            this.dayOccurrence = dayOccurrence;
            this.changedFields = changedFields.add("dayOccurrence");
            return this;
        }

        public Builder dayOfWeek(DayOfWeek dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
            this.changedFields = changedFields.add("dayOfWeek");
            return this;
        }

        public Builder month(Integer month) {
            this.month = month;
            this.changedFields = changedFields.add("month");
            return this;
        }

        public Builder year(Integer year) {
            this.year = year;
            this.changedFields = changedFields.add("year");
            return this;
        }

        public Builder daylightBias(Integer daylightBias) {
            this.daylightBias = daylightBias;
            this.changedFields = changedFields.add("daylightBias");
            return this;
        }

        public DaylightTimeZoneOffset build() {
            DaylightTimeZoneOffset _x = new DaylightTimeZoneOffset();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.daylightTimeZoneOffset";
            _x.time = time;
            _x.dayOccurrence = dayOccurrence;
            _x.dayOfWeek = dayOfWeek;
            _x.month = month;
            _x.year = year;
            _x.daylightBias = daylightBias;
            return _x;
        }
    }

    private DaylightTimeZoneOffset _copy() {
        DaylightTimeZoneOffset _x = new DaylightTimeZoneOffset();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.time = time;
        _x.dayOccurrence = dayOccurrence;
        _x.dayOfWeek = dayOfWeek;
        _x.month = month;
        _x.year = year;
        _x.daylightBias = daylightBias;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DaylightTimeZoneOffset[");
        b.append("time=");
        b.append(this.time);
        b.append(", ");
        b.append("dayOccurrence=");
        b.append(this.dayOccurrence);
        b.append(", ");
        b.append("dayOfWeek=");
        b.append(this.dayOfWeek);
        b.append(", ");
        b.append("month=");
        b.append(this.month);
        b.append(", ");
        b.append("year=");
        b.append(this.year);
        b.append(", ");
        b.append("daylightBias=");
        b.append(this.daylightBias);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
