package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "name", 
    "unique", 
    "searchable"})
@JsonInclude(Include.NON_NULL)
public class DataStoreField implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("unique")
    protected Boolean unique;

    @JsonProperty("searchable")
    protected Boolean searchable;

    protected DataStoreField() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.dataStoreField";
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public DataStoreField withName(String name) {
        DataStoreField _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.dataStoreField");
        _x.name = name;
        return _x;
    }

    @Property(name="unique")
    @JsonIgnore
    public Optional<Boolean> getUnique() {
        return Optional.ofNullable(unique);
    }

    public DataStoreField withUnique(Boolean unique) {
        DataStoreField _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.dataStoreField");
        _x.unique = unique;
        return _x;
    }

    @Property(name="searchable")
    @JsonIgnore
    public Optional<Boolean> getSearchable() {
        return Optional.ofNullable(searchable);
    }

    public DataStoreField withSearchable(Boolean searchable) {
        DataStoreField _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.dataStoreField");
        _x.searchable = searchable;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private Boolean unique;
        private Boolean searchable;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder unique(Boolean unique) {
            this.unique = unique;
            this.changedFields = changedFields.add("unique");
            return this;
        }

        public Builder searchable(Boolean searchable) {
            this.searchable = searchable;
            this.changedFields = changedFields.add("searchable");
            return this;
        }

        public DataStoreField build() {
            DataStoreField _x = new DataStoreField();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.dataStoreField";
            _x.name = name;
            _x.unique = unique;
            _x.searchable = searchable;
            return _x;
        }
    }

    private DataStoreField _copy() {
        DataStoreField _x = new DataStoreField();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.name = name;
        _x.unique = unique;
        _x.searchable = searchable;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DataStoreField[");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("unique=");
        b.append(this.unique);
        b.append(", ");
        b.append("searchable=");
        b.append(this.searchable);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
