package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.LocalTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.DayOfWeek;


/**
 * <i>“Custom update time window”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "startDay", 
    "endDay", 
    "startTime", 
    "endTime"})
@JsonInclude(Include.NON_NULL)
public class CustomUpdateTimeWindow implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("startDay")
    protected DayOfWeek startDay;

    @JsonProperty("endDay")
    protected DayOfWeek endDay;

    @JsonProperty("startTime")
    protected LocalTime startTime;

    @JsonProperty("endTime")
    protected LocalTime endTime;

    protected CustomUpdateTimeWindow() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.customUpdateTimeWindow";
    }

    /**
     * <i>“Start day of the time window”</i>
     * 
     * @return property startDay
     */
    @Property(name="startDay")
    @JsonIgnore
    public Optional<DayOfWeek> getStartDay() {
        return Optional.ofNullable(startDay);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code startDay} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Start day of the time window”</i>
     * 
     * @param startDay
     *            new value of {@code startDay} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startDay} field changed
     */
    public CustomUpdateTimeWindow withStartDay(DayOfWeek startDay) {
        CustomUpdateTimeWindow _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.customUpdateTimeWindow");
        _x.startDay = startDay;
        return _x;
    }

    /**
     * <i>“End day of the time window”</i>
     * 
     * @return property endDay
     */
    @Property(name="endDay")
    @JsonIgnore
    public Optional<DayOfWeek> getEndDay() {
        return Optional.ofNullable(endDay);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code endDay} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“End day of the time window”</i>
     * 
     * @param endDay
     *            new value of {@code endDay} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code endDay} field changed
     */
    public CustomUpdateTimeWindow withEndDay(DayOfWeek endDay) {
        CustomUpdateTimeWindow _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.customUpdateTimeWindow");
        _x.endDay = endDay;
        return _x;
    }

    /**
     * <i>“Start time of the time window”</i>
     * 
     * @return property startTime
     */
    @Property(name="startTime")
    @JsonIgnore
    public Optional<LocalTime> getStartTime() {
        return Optional.ofNullable(startTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code startTime} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Start time of the time window”</i>
     * 
     * @param startTime
     *            new value of {@code startTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code startTime} field changed
     */
    public CustomUpdateTimeWindow withStartTime(LocalTime startTime) {
        CustomUpdateTimeWindow _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.customUpdateTimeWindow");
        _x.startTime = startTime;
        return _x;
    }

    /**
     * <i>“End time of the time window”</i>
     * 
     * @return property endTime
     */
    @Property(name="endTime")
    @JsonIgnore
    public Optional<LocalTime> getEndTime() {
        return Optional.ofNullable(endTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code endTime} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“End time of the time window”</i>
     * 
     * @param endTime
     *            new value of {@code endTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code endTime} field changed
     */
    public CustomUpdateTimeWindow withEndTime(LocalTime endTime) {
        CustomUpdateTimeWindow _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.customUpdateTimeWindow");
        _x.endTime = endTime;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private DayOfWeek startDay;
        private DayOfWeek endDay;
        private LocalTime startTime;
        private LocalTime endTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Start day of the time window”</i>
         * 
         * @param startDay
         *            value of {@code startDay} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startDay(DayOfWeek startDay) {
            this.startDay = startDay;
            this.changedFields = changedFields.add("startDay");
            return this;
        }

        /**
         * <i>“End day of the time window”</i>
         * 
         * @param endDay
         *            value of {@code endDay} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder endDay(DayOfWeek endDay) {
            this.endDay = endDay;
            this.changedFields = changedFields.add("endDay");
            return this;
        }

        /**
         * <i>“Start time of the time window”</i>
         * 
         * @param startTime
         *            value of {@code startTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder startTime(LocalTime startTime) {
            this.startTime = startTime;
            this.changedFields = changedFields.add("startTime");
            return this;
        }

        /**
         * <i>“End time of the time window”</i>
         * 
         * @param endTime
         *            value of {@code endTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder endTime(LocalTime endTime) {
            this.endTime = endTime;
            this.changedFields = changedFields.add("endTime");
            return this;
        }

        public CustomUpdateTimeWindow build() {
            CustomUpdateTimeWindow _x = new CustomUpdateTimeWindow();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.customUpdateTimeWindow";
            _x.startDay = startDay;
            _x.endDay = endDay;
            _x.startTime = startTime;
            _x.endTime = endTime;
            return _x;
        }
    }

    private CustomUpdateTimeWindow _copy() {
        CustomUpdateTimeWindow _x = new CustomUpdateTimeWindow();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.startDay = startDay;
        _x.endDay = endDay;
        _x.startTime = startTime;
        _x.endTime = endTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CustomUpdateTimeWindow[");
        b.append("startDay=");
        b.append(this.startDay);
        b.append(", ");
        b.append("endDay=");
        b.append(this.endDay);
        b.append(", ");
        b.append("startTime=");
        b.append(this.startTime);
        b.append(", ");
        b.append("endTime=");
        b.append(this.endTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
