package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "bias", 
    "standardOffset", 
    "daylightOffset"})
@JsonInclude(Include.NON_NULL)
public class CustomTimeZone extends TimeZoneBase implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("bias")
    protected Integer bias;

    @JsonProperty("standardOffset")
    protected StandardTimeZoneOffset standardOffset;

    @JsonProperty("daylightOffset")
    protected DaylightTimeZoneOffset daylightOffset;

    protected CustomTimeZone() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.customTimeZone";
    }

    @Property(name="bias")
    @JsonIgnore
    public Optional<Integer> getBias() {
        return Optional.ofNullable(bias);
    }

    public CustomTimeZone withBias(Integer bias) {
        CustomTimeZone _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.customTimeZone");
        _x.bias = bias;
        return _x;
    }

    @Property(name="standardOffset")
    @JsonIgnore
    public Optional<StandardTimeZoneOffset> getStandardOffset() {
        return Optional.ofNullable(standardOffset);
    }

    public CustomTimeZone withStandardOffset(StandardTimeZoneOffset standardOffset) {
        CustomTimeZone _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.customTimeZone");
        _x.standardOffset = standardOffset;
        return _x;
    }

    @Property(name="daylightOffset")
    @JsonIgnore
    public Optional<DaylightTimeZoneOffset> getDaylightOffset() {
        return Optional.ofNullable(daylightOffset);
    }

    public CustomTimeZone withDaylightOffset(DaylightTimeZoneOffset daylightOffset) {
        CustomTimeZone _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.customTimeZone");
        _x.daylightOffset = daylightOffset;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCustomTimeZone() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private Integer bias;
        private StandardTimeZoneOffset standardOffset;
        private DaylightTimeZoneOffset daylightOffset;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder bias(Integer bias) {
            this.bias = bias;
            this.changedFields = changedFields.add("bias");
            return this;
        }

        public Builder standardOffset(StandardTimeZoneOffset standardOffset) {
            this.standardOffset = standardOffset;
            this.changedFields = changedFields.add("standardOffset");
            return this;
        }

        public Builder daylightOffset(DaylightTimeZoneOffset daylightOffset) {
            this.daylightOffset = daylightOffset;
            this.changedFields = changedFields.add("daylightOffset");
            return this;
        }

        public CustomTimeZone build() {
            CustomTimeZone _x = new CustomTimeZone();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.customTimeZone";
            _x.name = name;
            _x.bias = bias;
            _x.standardOffset = standardOffset;
            _x.daylightOffset = daylightOffset;
            return _x;
        }
    }

    private CustomTimeZone _copy() {
        CustomTimeZone _x = new CustomTimeZone();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.name = name;
        _x.bias = bias;
        _x.standardOffset = standardOffset;
        _x.daylightOffset = daylightOffset;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CustomTimeZone[");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("bias=");
        b.append(this.bias);
        b.append(", ");
        b.append("standardOffset=");
        b.append(this.standardOffset);
        b.append(", ");
        b.append("daylightOffset=");
        b.append(this.daylightOffset);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
