package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "name", 
    "properties"})
@JsonInclude(Include.NON_NULL)
public class CustomAction extends InformationProtectionAction implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("properties")
    protected List<KeyValuePair> properties;

    @JsonProperty("properties@nextLink")
    protected String propertiesNextLink;

    protected CustomAction() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.customAction";
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public CustomAction withName(String name) {
        CustomAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.customAction");
        _x.name = name;
        return _x;
    }

    @Property(name="properties")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getProperties() {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, properties, Optional.ofNullable(propertiesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="properties")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getProperties(HttpRequestOptions options) {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, properties, Optional.ofNullable(propertiesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCustomAction() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private List<KeyValuePair> properties;
        private String propertiesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder properties(List<KeyValuePair> properties) {
            this.properties = properties;
            this.changedFields = changedFields.add("properties");
            return this;
        }

        public Builder properties(KeyValuePair... properties) {
            return properties(Arrays.asList(properties));
        }

        public Builder propertiesNextLink(String propertiesNextLink) {
            this.propertiesNextLink = propertiesNextLink;
            this.changedFields = changedFields.add("properties");
            return this;
        }

        public CustomAction build() {
            CustomAction _x = new CustomAction();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.customAction";
            _x.name = name;
            _x.properties = properties;
            _x.propertiesNextLink = propertiesNextLink;
            return _x;
        }
    }

    private CustomAction _copy() {
        CustomAction _x = new CustomAction();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.name = name;
        _x.properties = properties;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CustomAction[");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("properties=");
        b.append(this.properties);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
