package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "sourceId", 
    "targetId", 
    "errorDetails"})
@JsonInclude(Include.NON_NULL)
public class ConvertIdResult implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("sourceId")
    protected String sourceId;

    @JsonProperty("targetId")
    protected String targetId;

    @JsonProperty("errorDetails")
    protected GenericError errorDetails;

    protected ConvertIdResult() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.convertIdResult";
    }

    @Property(name="sourceId")
    @JsonIgnore
    public Optional<String> getSourceId() {
        return Optional.ofNullable(sourceId);
    }

    public ConvertIdResult withSourceId(String sourceId) {
        ConvertIdResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.convertIdResult");
        _x.sourceId = sourceId;
        return _x;
    }

    @Property(name="targetId")
    @JsonIgnore
    public Optional<String> getTargetId() {
        return Optional.ofNullable(targetId);
    }

    public ConvertIdResult withTargetId(String targetId) {
        ConvertIdResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.convertIdResult");
        _x.targetId = targetId;
        return _x;
    }

    @Property(name="errorDetails")
    @JsonIgnore
    public Optional<GenericError> getErrorDetails() {
        return Optional.ofNullable(errorDetails);
    }

    public ConvertIdResult withErrorDetails(GenericError errorDetails) {
        ConvertIdResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.convertIdResult");
        _x.errorDetails = errorDetails;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String sourceId;
        private String targetId;
        private GenericError errorDetails;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder sourceId(String sourceId) {
            this.sourceId = sourceId;
            this.changedFields = changedFields.add("sourceId");
            return this;
        }

        public Builder targetId(String targetId) {
            this.targetId = targetId;
            this.changedFields = changedFields.add("targetId");
            return this;
        }

        public Builder errorDetails(GenericError errorDetails) {
            this.errorDetails = errorDetails;
            this.changedFields = changedFields.add("errorDetails");
            return this;
        }

        public ConvertIdResult build() {
            ConvertIdResult _x = new ConvertIdResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.convertIdResult";
            _x.sourceId = sourceId;
            _x.targetId = targetId;
            _x.errorDetails = errorDetails;
            return _x;
        }
    }

    private ConvertIdResult _copy() {
        ConvertIdResult _x = new ConvertIdResult();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.sourceId = sourceId;
        _x.targetId = targetId;
        _x.errorDetails = errorDetails;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ConvertIdResult[");
        b.append("sourceId=");
        b.append(this.sourceId);
        b.append(", ");
        b.append("targetId=");
        b.append(this.targetId);
        b.append(", ");
        b.append("errorDetails=");
        b.append(this.errorDetails);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
