package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "controlCategory", 
    "controlName", 
    "description", 
    "score"})
@JsonInclude(Include.NON_NULL)
public class ControlScore implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("controlCategory")
    protected String controlCategory;

    @JsonProperty("controlName")
    protected String controlName;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("score")
    protected Double score;

    protected ControlScore() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.controlScore";
    }

    @Property(name="controlCategory")
    @JsonIgnore
    public Optional<String> getControlCategory() {
        return Optional.ofNullable(controlCategory);
    }

    public ControlScore withControlCategory(String controlCategory) {
        ControlScore _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.controlScore");
        _x.controlCategory = controlCategory;
        return _x;
    }

    @Property(name="controlName")
    @JsonIgnore
    public Optional<String> getControlName() {
        return Optional.ofNullable(controlName);
    }

    public ControlScore withControlName(String controlName) {
        ControlScore _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.controlScore");
        _x.controlName = controlName;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public ControlScore withDescription(String description) {
        ControlScore _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.controlScore");
        _x.description = description;
        return _x;
    }

    @Property(name="score")
    @JsonIgnore
    public Optional<Double> getScore() {
        return Optional.ofNullable(score);
    }

    public ControlScore withScore(Double score) {
        ControlScore _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.controlScore");
        _x.score = score;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String controlCategory;
        private String controlName;
        private String description;
        private Double score;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder controlCategory(String controlCategory) {
            this.controlCategory = controlCategory;
            this.changedFields = changedFields.add("controlCategory");
            return this;
        }

        public Builder controlName(String controlName) {
            this.controlName = controlName;
            this.changedFields = changedFields.add("controlName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder score(Double score) {
            this.score = score;
            this.changedFields = changedFields.add("score");
            return this;
        }

        public ControlScore build() {
            ControlScore _x = new ControlScore();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.controlScore";
            _x.controlCategory = controlCategory;
            _x.controlName = controlName;
            _x.description = description;
            _x.score = score;
            return _x;
        }
    }

    private ControlScore _copy() {
        ControlScore _x = new ControlScore();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.controlCategory = controlCategory;
        _x.controlName = controlName;
        _x.description = description;
        _x.score = score;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ControlScore[");
        b.append("controlCategory=");
        b.append(this.controlCategory);
        b.append(", ");
        b.append("controlName=");
        b.append(this.controlName);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("score=");
        b.append(this.score);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
