package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "extensions", 
    "metadata", 
    "lastModifiedDateTime", 
    "lastModifiedBy"})
@JsonInclude(Include.NON_NULL)
public class ContentProperties implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("extensions")
    protected List<String> extensions;

    @JsonProperty("extensions@nextLink")
    protected String extensionsNextLink;

    @JsonProperty("metadata")
    protected ContentMetadata metadata;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("lastModifiedBy")
    protected String lastModifiedBy;

    protected ContentProperties() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.contentProperties";
    }

    @Property(name="extensions")
    @JsonIgnore
    public CollectionPage<String> getExtensions() {
        return new CollectionPage<String>(contextPath, String.class, extensions, Optional.ofNullable(extensionsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="extensions")
    @JsonIgnore
    public CollectionPage<String> getExtensions(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, extensions, Optional.ofNullable(extensionsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="metadata")
    @JsonIgnore
    public Optional<ContentMetadata> getMetadata() {
        return Optional.ofNullable(metadata);
    }

    public ContentProperties withMetadata(ContentMetadata metadata) {
        ContentProperties _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contentProperties");
        _x.metadata = metadata;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public ContentProperties withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        ContentProperties _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contentProperties");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="lastModifiedBy")
    @JsonIgnore
    public Optional<String> getLastModifiedBy() {
        return Optional.ofNullable(lastModifiedBy);
    }

    public ContentProperties withLastModifiedBy(String lastModifiedBy) {
        ContentProperties _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contentProperties");
        _x.lastModifiedBy = lastModifiedBy;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> extensions;
        private String extensionsNextLink;
        private ContentMetadata metadata;
        private OffsetDateTime lastModifiedDateTime;
        private String lastModifiedBy;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder extensions(List<String> extensions) {
            this.extensions = extensions;
            this.changedFields = changedFields.add("extensions");
            return this;
        }

        public Builder extensions(String... extensions) {
            return extensions(Arrays.asList(extensions));
        }

        public Builder extensionsNextLink(String extensionsNextLink) {
            this.extensionsNextLink = extensionsNextLink;
            this.changedFields = changedFields.add("extensions");
            return this;
        }

        public Builder metadata(ContentMetadata metadata) {
            this.metadata = metadata;
            this.changedFields = changedFields.add("metadata");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            this.changedFields = changedFields.add("lastModifiedBy");
            return this;
        }

        public ContentProperties build() {
            ContentProperties _x = new ContentProperties();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.contentProperties";
            _x.extensions = extensions;
            _x.extensionsNextLink = extensionsNextLink;
            _x.metadata = metadata;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.lastModifiedBy = lastModifiedBy;
            return _x;
        }
    }

    private ContentProperties _copy() {
        ContentProperties _x = new ContentProperties();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.extensions = extensions;
        _x.metadata = metadata;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.lastModifiedBy = lastModifiedBy;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ContentProperties[");
        b.append("extensions=");
        b.append(this.extensions);
        b.append(", ");
        b.append("metadata=");
        b.append(this.metadata);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("lastModifiedBy=");
        b.append(this.lastModifiedBy);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
