package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "id", 
    "description"})
@JsonInclude(Include.NON_NULL)
public class ConnectedOrganizationMembers extends UserSet implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("id")
    protected String id;

    @JsonProperty("description")
    protected String description;

    protected ConnectedOrganizationMembers() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.connectedOrganizationMembers";
    }

    @Property(name="id")
    @JsonIgnore
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    public ConnectedOrganizationMembers withId(String id) {
        ConnectedOrganizationMembers _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.connectedOrganizationMembers");
        _x.id = id;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public ConnectedOrganizationMembers withDescription(String description) {
        ConnectedOrganizationMembers _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.connectedOrganizationMembers");
        _x.description = description;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderConnectedOrganizationMembers() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean isBackup;
        private String id;
        private String description;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder isBackup(Boolean isBackup) {
            this.isBackup = isBackup;
            this.changedFields = changedFields.add("isBackup");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public ConnectedOrganizationMembers build() {
            ConnectedOrganizationMembers _x = new ConnectedOrganizationMembers();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.connectedOrganizationMembers";
            _x.isBackup = isBackup;
            _x.id = id;
            _x.description = description;
            return _x;
        }
    }

    private ConnectedOrganizationMembers _copy() {
        ConnectedOrganizationMembers _x = new ConnectedOrganizationMembers();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.isBackup = isBackup;
        _x.id = id;
        _x.description = description;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ConnectedOrganizationMembers[");
        b.append("isBackup=");
        b.append(this.isBackup);
        b.append(", ");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
