package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“configuration Manager client enabled features”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "inventory", 
    "modernApps", 
    "resourceAccess", 
    "deviceConfiguration", 
    "compliancePolicy", 
    "windowsUpdateForBusiness", 
    "endpointProtection", 
    "officeApps"})
@JsonInclude(Include.NON_NULL)
public class ConfigurationManagerClientEnabledFeatures implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("inventory")
    protected Boolean inventory;

    @JsonProperty("modernApps")
    protected Boolean modernApps;

    @JsonProperty("resourceAccess")
    protected Boolean resourceAccess;

    @JsonProperty("deviceConfiguration")
    protected Boolean deviceConfiguration;

    @JsonProperty("compliancePolicy")
    protected Boolean compliancePolicy;

    @JsonProperty("windowsUpdateForBusiness")
    protected Boolean windowsUpdateForBusiness;

    @JsonProperty("endpointProtection")
    protected Boolean endpointProtection;

    @JsonProperty("officeApps")
    protected Boolean officeApps;

    protected ConfigurationManagerClientEnabledFeatures() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.configurationManagerClientEnabledFeatures";
    }

    /**
     * <i>“Whether inventory is managed by Intune”</i>
     * 
     * @return property inventory
     */
    @Property(name="inventory")
    @JsonIgnore
    public Optional<Boolean> getInventory() {
        return Optional.ofNullable(inventory);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code inventory} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Whether inventory is managed by Intune”</i>
     * 
     * @param inventory
     *            new value of {@code inventory} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code inventory} field changed
     */
    public ConfigurationManagerClientEnabledFeatures withInventory(Boolean inventory) {
        ConfigurationManagerClientEnabledFeatures _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.configurationManagerClientEnabledFeatures");
        _x.inventory = inventory;
        return _x;
    }

    /**
     * <i>“Whether modern application is managed by Intune”</i>
     * 
     * @return property modernApps
     */
    @Property(name="modernApps")
    @JsonIgnore
    public Optional<Boolean> getModernApps() {
        return Optional.ofNullable(modernApps);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code modernApps} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Whether modern application is managed by Intune”</i>
     * 
     * @param modernApps
     *            new value of {@code modernApps} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code modernApps} field changed
     */
    public ConfigurationManagerClientEnabledFeatures withModernApps(Boolean modernApps) {
        ConfigurationManagerClientEnabledFeatures _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.configurationManagerClientEnabledFeatures");
        _x.modernApps = modernApps;
        return _x;
    }

    /**
     * <i>“Whether resource access is managed by Intune”</i>
     * 
     * @return property resourceAccess
     */
    @Property(name="resourceAccess")
    @JsonIgnore
    public Optional<Boolean> getResourceAccess() {
        return Optional.ofNullable(resourceAccess);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code resourceAccess}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Whether resource access is managed by Intune”</i>
     * 
     * @param resourceAccess
     *            new value of {@code resourceAccess} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code resourceAccess} field changed
     */
    public ConfigurationManagerClientEnabledFeatures withResourceAccess(Boolean resourceAccess) {
        ConfigurationManagerClientEnabledFeatures _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.configurationManagerClientEnabledFeatures");
        _x.resourceAccess = resourceAccess;
        return _x;
    }

    /**
     * <i>“Whether device configuration is managed by Intune”</i>
     * 
     * @return property deviceConfiguration
     */
    @Property(name="deviceConfiguration")
    @JsonIgnore
    public Optional<Boolean> getDeviceConfiguration() {
        return Optional.ofNullable(deviceConfiguration);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceConfiguration} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Whether device configuration is managed by Intune”</i>
     * 
     * @param deviceConfiguration
     *            new value of {@code deviceConfiguration} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceConfiguration} field changed
     */
    public ConfigurationManagerClientEnabledFeatures withDeviceConfiguration(Boolean deviceConfiguration) {
        ConfigurationManagerClientEnabledFeatures _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.configurationManagerClientEnabledFeatures");
        _x.deviceConfiguration = deviceConfiguration;
        return _x;
    }

    /**
     * <i>“Whether compliance policy is managed by Intune”</i>
     * 
     * @return property compliancePolicy
     */
    @Property(name="compliancePolicy")
    @JsonIgnore
    public Optional<Boolean> getCompliancePolicy() {
        return Optional.ofNullable(compliancePolicy);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code compliancePolicy}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Whether compliance policy is managed by Intune”</i>
     * 
     * @param compliancePolicy
     *            new value of {@code compliancePolicy} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code compliancePolicy} field changed
     */
    public ConfigurationManagerClientEnabledFeatures withCompliancePolicy(Boolean compliancePolicy) {
        ConfigurationManagerClientEnabledFeatures _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.configurationManagerClientEnabledFeatures");
        _x.compliancePolicy = compliancePolicy;
        return _x;
    }

    /**
     * <i>“Whether Windows Update for Business is managed by Intune”</i>
     * 
     * @return property windowsUpdateForBusiness
     */
    @Property(name="windowsUpdateForBusiness")
    @JsonIgnore
    public Optional<Boolean> getWindowsUpdateForBusiness() {
        return Optional.ofNullable(windowsUpdateForBusiness);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * windowsUpdateForBusiness} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Whether Windows Update for Business is managed by Intune”</i>
     * 
     * @param windowsUpdateForBusiness
     *            new value of {@code windowsUpdateForBusiness} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windowsUpdateForBusiness} field changed
     */
    public ConfigurationManagerClientEnabledFeatures withWindowsUpdateForBusiness(Boolean windowsUpdateForBusiness) {
        ConfigurationManagerClientEnabledFeatures _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.configurationManagerClientEnabledFeatures");
        _x.windowsUpdateForBusiness = windowsUpdateForBusiness;
        return _x;
    }

    /**
     * <i>“Whether Endpoint Protection is managed by Intune”</i>
     * 
     * @return property endpointProtection
     */
    @Property(name="endpointProtection")
    @JsonIgnore
    public Optional<Boolean> getEndpointProtection() {
        return Optional.ofNullable(endpointProtection);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * endpointProtection} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Whether Endpoint Protection is managed by Intune”</i>
     * 
     * @param endpointProtection
     *            new value of {@code endpointProtection} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code endpointProtection} field changed
     */
    public ConfigurationManagerClientEnabledFeatures withEndpointProtection(Boolean endpointProtection) {
        ConfigurationManagerClientEnabledFeatures _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.configurationManagerClientEnabledFeatures");
        _x.endpointProtection = endpointProtection;
        return _x;
    }

    /**
     * <i>“Whether Office application is managed by Intune”</i>
     * 
     * @return property officeApps
     */
    @Property(name="officeApps")
    @JsonIgnore
    public Optional<Boolean> getOfficeApps() {
        return Optional.ofNullable(officeApps);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code officeApps} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Whether Office application is managed by Intune”</i>
     * 
     * @param officeApps
     *            new value of {@code officeApps} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code officeApps} field changed
     */
    public ConfigurationManagerClientEnabledFeatures withOfficeApps(Boolean officeApps) {
        ConfigurationManagerClientEnabledFeatures _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.configurationManagerClientEnabledFeatures");
        _x.officeApps = officeApps;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean inventory;
        private Boolean modernApps;
        private Boolean resourceAccess;
        private Boolean deviceConfiguration;
        private Boolean compliancePolicy;
        private Boolean windowsUpdateForBusiness;
        private Boolean endpointProtection;
        private Boolean officeApps;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Whether inventory is managed by Intune”</i>
         * 
         * @param inventory
         *            value of {@code inventory} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder inventory(Boolean inventory) {
            this.inventory = inventory;
            this.changedFields = changedFields.add("inventory");
            return this;
        }

        /**
         * <i>“Whether modern application is managed by Intune”</i>
         * 
         * @param modernApps
         *            value of {@code modernApps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder modernApps(Boolean modernApps) {
            this.modernApps = modernApps;
            this.changedFields = changedFields.add("modernApps");
            return this;
        }

        /**
         * <i>“Whether resource access is managed by Intune”</i>
         * 
         * @param resourceAccess
         *            value of {@code resourceAccess} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder resourceAccess(Boolean resourceAccess) {
            this.resourceAccess = resourceAccess;
            this.changedFields = changedFields.add("resourceAccess");
            return this;
        }

        /**
         * <i>“Whether device configuration is managed by Intune”</i>
         * 
         * @param deviceConfiguration
         *            value of {@code deviceConfiguration} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceConfiguration(Boolean deviceConfiguration) {
            this.deviceConfiguration = deviceConfiguration;
            this.changedFields = changedFields.add("deviceConfiguration");
            return this;
        }

        /**
         * <i>“Whether compliance policy is managed by Intune”</i>
         * 
         * @param compliancePolicy
         *            value of {@code compliancePolicy} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder compliancePolicy(Boolean compliancePolicy) {
            this.compliancePolicy = compliancePolicy;
            this.changedFields = changedFields.add("compliancePolicy");
            return this;
        }

        /**
         * <i>“Whether Windows Update for Business is managed by Intune”</i>
         * 
         * @param windowsUpdateForBusiness
         *            value of {@code windowsUpdateForBusiness} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsUpdateForBusiness(Boolean windowsUpdateForBusiness) {
            this.windowsUpdateForBusiness = windowsUpdateForBusiness;
            this.changedFields = changedFields.add("windowsUpdateForBusiness");
            return this;
        }

        /**
         * <i>“Whether Endpoint Protection is managed by Intune”</i>
         * 
         * @param endpointProtection
         *            value of {@code endpointProtection} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder endpointProtection(Boolean endpointProtection) {
            this.endpointProtection = endpointProtection;
            this.changedFields = changedFields.add("endpointProtection");
            return this;
        }

        /**
         * <i>“Whether Office application is managed by Intune”</i>
         * 
         * @param officeApps
         *            value of {@code officeApps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder officeApps(Boolean officeApps) {
            this.officeApps = officeApps;
            this.changedFields = changedFields.add("officeApps");
            return this;
        }

        public ConfigurationManagerClientEnabledFeatures build() {
            ConfigurationManagerClientEnabledFeatures _x = new ConfigurationManagerClientEnabledFeatures();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.configurationManagerClientEnabledFeatures";
            _x.inventory = inventory;
            _x.modernApps = modernApps;
            _x.resourceAccess = resourceAccess;
            _x.deviceConfiguration = deviceConfiguration;
            _x.compliancePolicy = compliancePolicy;
            _x.windowsUpdateForBusiness = windowsUpdateForBusiness;
            _x.endpointProtection = endpointProtection;
            _x.officeApps = officeApps;
            return _x;
        }
    }

    private ConfigurationManagerClientEnabledFeatures _copy() {
        ConfigurationManagerClientEnabledFeatures _x = new ConfigurationManagerClientEnabledFeatures();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.inventory = inventory;
        _x.modernApps = modernApps;
        _x.resourceAccess = resourceAccess;
        _x.deviceConfiguration = deviceConfiguration;
        _x.compliancePolicy = compliancePolicy;
        _x.windowsUpdateForBusiness = windowsUpdateForBusiness;
        _x.endpointProtection = endpointProtection;
        _x.officeApps = officeApps;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ConfigurationManagerClientEnabledFeatures[");
        b.append("inventory=");
        b.append(this.inventory);
        b.append(", ");
        b.append("modernApps=");
        b.append(this.modernApps);
        b.append(", ");
        b.append("resourceAccess=");
        b.append(this.resourceAccess);
        b.append(", ");
        b.append("deviceConfiguration=");
        b.append(this.deviceConfiguration);
        b.append(", ");
        b.append("compliancePolicy=");
        b.append(this.compliancePolicy);
        b.append(", ");
        b.append("windowsUpdateForBusiness=");
        b.append(this.windowsUpdateForBusiness);
        b.append(", ");
        b.append("endpointProtection=");
        b.append(this.endpointProtection);
        b.append(", ");
        b.append("officeApps=");
        b.append(this.officeApps);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
