package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.ActionState;
import odata.msgraph.client.beta.enums.ConfigurationManagerActionDeliveryStatus;


/**
 * <i>“Result of the ConfigurationManager action”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "actionDeliveryStatus", 
    "errorCode"})
@JsonInclude(Include.NON_NULL)
public class ConfigurationManagerActionResult extends DeviceActionResult implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("actionDeliveryStatus")
    protected ConfigurationManagerActionDeliveryStatus actionDeliveryStatus;

    @JsonProperty("errorCode")
    protected Integer errorCode;

    protected ConfigurationManagerActionResult() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.configurationManagerActionResult";
    }

    /**
     * <i>“State of the action being delivered to on-prem server”</i>
     * 
     * @return property actionDeliveryStatus
     */
    @Property(name="actionDeliveryStatus")
    @JsonIgnore
    public Optional<ConfigurationManagerActionDeliveryStatus> getActionDeliveryStatus() {
        return Optional.ofNullable(actionDeliveryStatus);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * actionDeliveryStatus} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“State of the action being delivered to on-prem server”</i>
     * 
     * @param actionDeliveryStatus
     *            new value of {@code actionDeliveryStatus} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code actionDeliveryStatus} field changed
     */
    public ConfigurationManagerActionResult withActionDeliveryStatus(ConfigurationManagerActionDeliveryStatus actionDeliveryStatus) {
        ConfigurationManagerActionResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.configurationManagerActionResult");
        _x.actionDeliveryStatus = actionDeliveryStatus;
        return _x;
    }

    /**
     * <i>“Error code of Configuration Manager action from client”</i>
     * 
     * @return property errorCode
     */
    @Property(name="errorCode")
    @JsonIgnore
    public Optional<Integer> getErrorCode() {
        return Optional.ofNullable(errorCode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code errorCode} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Error code of Configuration Manager action from client”</i>
     * 
     * @param errorCode
     *            new value of {@code errorCode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code errorCode} field changed
     */
    public ConfigurationManagerActionResult withErrorCode(Integer errorCode) {
        ConfigurationManagerActionResult _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.configurationManagerActionResult");
        _x.errorCode = errorCode;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderConfigurationManagerActionResult() {
        return new Builder();
    }

    public static final class Builder {
        private String actionName;
        private ActionState actionState;
        private OffsetDateTime startDateTime;
        private OffsetDateTime lastUpdatedDateTime;
        private ConfigurationManagerActionDeliveryStatus actionDeliveryStatus;
        private Integer errorCode;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder actionName(String actionName) {
            this.actionName = actionName;
            this.changedFields = changedFields.add("actionName");
            return this;
        }

        public Builder actionState(ActionState actionState) {
            this.actionState = actionState;
            this.changedFields = changedFields.add("actionState");
            return this;
        }

        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        public Builder lastUpdatedDateTime(OffsetDateTime lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            this.changedFields = changedFields.add("lastUpdatedDateTime");
            return this;
        }

        /**
         * <i>“State of the action being delivered to on-prem server”</i>
         * 
         * @param actionDeliveryStatus
         *            value of {@code actionDeliveryStatus} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder actionDeliveryStatus(ConfigurationManagerActionDeliveryStatus actionDeliveryStatus) {
            this.actionDeliveryStatus = actionDeliveryStatus;
            this.changedFields = changedFields.add("actionDeliveryStatus");
            return this;
        }

        /**
         * <i>“Error code of Configuration Manager action from client”</i>
         * 
         * @param errorCode
         *            value of {@code errorCode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder errorCode(Integer errorCode) {
            this.errorCode = errorCode;
            this.changedFields = changedFields.add("errorCode");
            return this;
        }

        public ConfigurationManagerActionResult build() {
            ConfigurationManagerActionResult _x = new ConfigurationManagerActionResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.configurationManagerActionResult";
            _x.actionName = actionName;
            _x.actionState = actionState;
            _x.startDateTime = startDateTime;
            _x.lastUpdatedDateTime = lastUpdatedDateTime;
            _x.actionDeliveryStatus = actionDeliveryStatus;
            _x.errorCode = errorCode;
            return _x;
        }
    }

    private ConfigurationManagerActionResult _copy() {
        ConfigurationManagerActionResult _x = new ConfigurationManagerActionResult();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.actionName = actionName;
        _x.actionState = actionState;
        _x.startDateTime = startDateTime;
        _x.lastUpdatedDateTime = lastUpdatedDateTime;
        _x.actionDeliveryStatus = actionDeliveryStatus;
        _x.errorCode = errorCode;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ConfigurationManagerActionResult[");
        b.append("actionName=");
        b.append(this.actionName);
        b.append(", ");
        b.append("actionState=");
        b.append(this.actionState);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("lastUpdatedDateTime=");
        b.append(this.lastUpdatedDateTime);
        b.append(", ");
        b.append("actionDeliveryStatus=");
        b.append(this.actionDeliveryStatus);
        b.append(", ");
        b.append("errorCode=");
        b.append(this.errorCode);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
