package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "authorizedApps"})
@JsonInclude(Include.NON_NULL)
public class Configuration implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("authorizedApps")
    protected List<String> authorizedApps;

    @JsonProperty("authorizedApps@nextLink")
    protected String authorizedAppsNextLink;

    protected Configuration() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.configuration";
    }

    @Property(name="authorizedApps")
    @JsonIgnore
    public CollectionPage<String> getAuthorizedApps() {
        return new CollectionPage<String>(contextPath, String.class, authorizedApps, Optional.ofNullable(authorizedAppsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="authorizedApps")
    @JsonIgnore
    public CollectionPage<String> getAuthorizedApps(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, authorizedApps, Optional.ofNullable(authorizedAppsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> authorizedApps;
        private String authorizedAppsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder authorizedApps(List<String> authorizedApps) {
            this.authorizedApps = authorizedApps;
            this.changedFields = changedFields.add("authorizedApps");
            return this;
        }

        public Builder authorizedApps(String... authorizedApps) {
            return authorizedApps(Arrays.asList(authorizedApps));
        }

        public Builder authorizedAppsNextLink(String authorizedAppsNextLink) {
            this.authorizedAppsNextLink = authorizedAppsNextLink;
            this.changedFields = changedFields.add("authorizedApps");
            return this;
        }

        public Configuration build() {
            Configuration _x = new Configuration();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.configuration";
            _x.authorizedApps = authorizedApps;
            _x.authorizedAppsNextLink = authorizedAppsNextLink;
            return _x;
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Configuration[");
        b.append("authorizedApps=");
        b.append(this.authorizedApps);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
