package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "applicationEnforcedRestrictions", 
    "cloudAppSecurity", 
    "signInFrequency", 
    "persistentBrowser"})
@JsonInclude(Include.NON_NULL)
public class ConditionalAccessSessionControls implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("applicationEnforcedRestrictions")
    protected ApplicationEnforcedRestrictionsSessionControl applicationEnforcedRestrictions;

    @JsonProperty("cloudAppSecurity")
    protected CloudAppSecuritySessionControl cloudAppSecurity;

    @JsonProperty("signInFrequency")
    protected SignInFrequencySessionControl signInFrequency;

    @JsonProperty("persistentBrowser")
    protected PersistentBrowserSessionControl persistentBrowser;

    protected ConditionalAccessSessionControls() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.conditionalAccessSessionControls";
    }

    @Property(name="applicationEnforcedRestrictions")
    @JsonIgnore
    public Optional<ApplicationEnforcedRestrictionsSessionControl> getApplicationEnforcedRestrictions() {
        return Optional.ofNullable(applicationEnforcedRestrictions);
    }

    public ConditionalAccessSessionControls withApplicationEnforcedRestrictions(ApplicationEnforcedRestrictionsSessionControl applicationEnforcedRestrictions) {
        ConditionalAccessSessionControls _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.conditionalAccessSessionControls");
        _x.applicationEnforcedRestrictions = applicationEnforcedRestrictions;
        return _x;
    }

    @Property(name="cloudAppSecurity")
    @JsonIgnore
    public Optional<CloudAppSecuritySessionControl> getCloudAppSecurity() {
        return Optional.ofNullable(cloudAppSecurity);
    }

    public ConditionalAccessSessionControls withCloudAppSecurity(CloudAppSecuritySessionControl cloudAppSecurity) {
        ConditionalAccessSessionControls _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.conditionalAccessSessionControls");
        _x.cloudAppSecurity = cloudAppSecurity;
        return _x;
    }

    @Property(name="signInFrequency")
    @JsonIgnore
    public Optional<SignInFrequencySessionControl> getSignInFrequency() {
        return Optional.ofNullable(signInFrequency);
    }

    public ConditionalAccessSessionControls withSignInFrequency(SignInFrequencySessionControl signInFrequency) {
        ConditionalAccessSessionControls _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.conditionalAccessSessionControls");
        _x.signInFrequency = signInFrequency;
        return _x;
    }

    @Property(name="persistentBrowser")
    @JsonIgnore
    public Optional<PersistentBrowserSessionControl> getPersistentBrowser() {
        return Optional.ofNullable(persistentBrowser);
    }

    public ConditionalAccessSessionControls withPersistentBrowser(PersistentBrowserSessionControl persistentBrowser) {
        ConditionalAccessSessionControls _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.conditionalAccessSessionControls");
        _x.persistentBrowser = persistentBrowser;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ApplicationEnforcedRestrictionsSessionControl applicationEnforcedRestrictions;
        private CloudAppSecuritySessionControl cloudAppSecurity;
        private SignInFrequencySessionControl signInFrequency;
        private PersistentBrowserSessionControl persistentBrowser;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder applicationEnforcedRestrictions(ApplicationEnforcedRestrictionsSessionControl applicationEnforcedRestrictions) {
            this.applicationEnforcedRestrictions = applicationEnforcedRestrictions;
            this.changedFields = changedFields.add("applicationEnforcedRestrictions");
            return this;
        }

        public Builder cloudAppSecurity(CloudAppSecuritySessionControl cloudAppSecurity) {
            this.cloudAppSecurity = cloudAppSecurity;
            this.changedFields = changedFields.add("cloudAppSecurity");
            return this;
        }

        public Builder signInFrequency(SignInFrequencySessionControl signInFrequency) {
            this.signInFrequency = signInFrequency;
            this.changedFields = changedFields.add("signInFrequency");
            return this;
        }

        public Builder persistentBrowser(PersistentBrowserSessionControl persistentBrowser) {
            this.persistentBrowser = persistentBrowser;
            this.changedFields = changedFields.add("persistentBrowser");
            return this;
        }

        public ConditionalAccessSessionControls build() {
            ConditionalAccessSessionControls _x = new ConditionalAccessSessionControls();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.conditionalAccessSessionControls";
            _x.applicationEnforcedRestrictions = applicationEnforcedRestrictions;
            _x.cloudAppSecurity = cloudAppSecurity;
            _x.signInFrequency = signInFrequency;
            _x.persistentBrowser = persistentBrowser;
            return _x;
        }
    }

    private ConditionalAccessSessionControls _copy() {
        ConditionalAccessSessionControls _x = new ConditionalAccessSessionControls();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.applicationEnforcedRestrictions = applicationEnforcedRestrictions;
        _x.cloudAppSecurity = cloudAppSecurity;
        _x.signInFrequency = signInFrequency;
        _x.persistentBrowser = persistentBrowser;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ConditionalAccessSessionControls[");
        b.append("applicationEnforcedRestrictions=");
        b.append(this.applicationEnforcedRestrictions);
        b.append(", ");
        b.append("cloudAppSecurity=");
        b.append(this.cloudAppSecurity);
        b.append(", ");
        b.append("signInFrequency=");
        b.append(this.signInFrequency);
        b.append(", ");
        b.append("persistentBrowser=");
        b.append(this.persistentBrowser);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
