package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.ConditionalAccessDevicePlatform;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "includePlatforms", 
    "excludePlatforms"})
@JsonInclude(Include.NON_NULL)
public class ConditionalAccessPlatforms implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("includePlatforms")
    protected List<ConditionalAccessDevicePlatform> includePlatforms;

    @JsonProperty("includePlatforms@nextLink")
    protected String includePlatformsNextLink;

    @JsonProperty("excludePlatforms")
    protected List<ConditionalAccessDevicePlatform> excludePlatforms;

    @JsonProperty("excludePlatforms@nextLink")
    protected String excludePlatformsNextLink;

    protected ConditionalAccessPlatforms() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.conditionalAccessPlatforms";
    }

    @Property(name="includePlatforms")
    @JsonIgnore
    public CollectionPage<ConditionalAccessDevicePlatform> getIncludePlatforms() {
        return new CollectionPage<ConditionalAccessDevicePlatform>(contextPath, ConditionalAccessDevicePlatform.class, includePlatforms, Optional.ofNullable(includePlatformsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="includePlatforms")
    @JsonIgnore
    public CollectionPage<ConditionalAccessDevicePlatform> getIncludePlatforms(HttpRequestOptions options) {
        return new CollectionPage<ConditionalAccessDevicePlatform>(contextPath, ConditionalAccessDevicePlatform.class, includePlatforms, Optional.ofNullable(includePlatformsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="excludePlatforms")
    @JsonIgnore
    public CollectionPage<ConditionalAccessDevicePlatform> getExcludePlatforms() {
        return new CollectionPage<ConditionalAccessDevicePlatform>(contextPath, ConditionalAccessDevicePlatform.class, excludePlatforms, Optional.ofNullable(excludePlatformsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="excludePlatforms")
    @JsonIgnore
    public CollectionPage<ConditionalAccessDevicePlatform> getExcludePlatforms(HttpRequestOptions options) {
        return new CollectionPage<ConditionalAccessDevicePlatform>(contextPath, ConditionalAccessDevicePlatform.class, excludePlatforms, Optional.ofNullable(excludePlatformsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<ConditionalAccessDevicePlatform> includePlatforms;
        private String includePlatformsNextLink;
        private List<ConditionalAccessDevicePlatform> excludePlatforms;
        private String excludePlatformsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder includePlatforms(List<ConditionalAccessDevicePlatform> includePlatforms) {
            this.includePlatforms = includePlatforms;
            this.changedFields = changedFields.add("includePlatforms");
            return this;
        }

        public Builder includePlatforms(ConditionalAccessDevicePlatform... includePlatforms) {
            return includePlatforms(Arrays.asList(includePlatforms));
        }

        public Builder includePlatformsNextLink(String includePlatformsNextLink) {
            this.includePlatformsNextLink = includePlatformsNextLink;
            this.changedFields = changedFields.add("includePlatforms");
            return this;
        }

        public Builder excludePlatforms(List<ConditionalAccessDevicePlatform> excludePlatforms) {
            this.excludePlatforms = excludePlatforms;
            this.changedFields = changedFields.add("excludePlatforms");
            return this;
        }

        public Builder excludePlatforms(ConditionalAccessDevicePlatform... excludePlatforms) {
            return excludePlatforms(Arrays.asList(excludePlatforms));
        }

        public Builder excludePlatformsNextLink(String excludePlatformsNextLink) {
            this.excludePlatformsNextLink = excludePlatformsNextLink;
            this.changedFields = changedFields.add("excludePlatforms");
            return this;
        }

        public ConditionalAccessPlatforms build() {
            ConditionalAccessPlatforms _x = new ConditionalAccessPlatforms();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.conditionalAccessPlatforms";
            _x.includePlatforms = includePlatforms;
            _x.includePlatformsNextLink = includePlatformsNextLink;
            _x.excludePlatforms = excludePlatforms;
            _x.excludePlatformsNextLink = excludePlatformsNextLink;
            return _x;
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ConditionalAccessPlatforms[");
        b.append("includePlatforms=");
        b.append(this.includePlatforms);
        b.append(", ");
        b.append("excludePlatforms=");
        b.append(this.excludePlatforms);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
