package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "includeLocations", 
    "excludeLocations"})
@JsonInclude(Include.NON_NULL)
public class ConditionalAccessLocations implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("includeLocations")
    protected List<String> includeLocations;

    @JsonProperty("includeLocations@nextLink")
    protected String includeLocationsNextLink;

    @JsonProperty("excludeLocations")
    protected List<String> excludeLocations;

    @JsonProperty("excludeLocations@nextLink")
    protected String excludeLocationsNextLink;

    protected ConditionalAccessLocations() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.conditionalAccessLocations";
    }

    @Property(name="includeLocations")
    @JsonIgnore
    public CollectionPage<String> getIncludeLocations() {
        return new CollectionPage<String>(contextPath, String.class, includeLocations, Optional.ofNullable(includeLocationsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="includeLocations")
    @JsonIgnore
    public CollectionPage<String> getIncludeLocations(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, includeLocations, Optional.ofNullable(includeLocationsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="excludeLocations")
    @JsonIgnore
    public CollectionPage<String> getExcludeLocations() {
        return new CollectionPage<String>(contextPath, String.class, excludeLocations, Optional.ofNullable(excludeLocationsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="excludeLocations")
    @JsonIgnore
    public CollectionPage<String> getExcludeLocations(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, excludeLocations, Optional.ofNullable(excludeLocationsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> includeLocations;
        private String includeLocationsNextLink;
        private List<String> excludeLocations;
        private String excludeLocationsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder includeLocations(List<String> includeLocations) {
            this.includeLocations = includeLocations;
            this.changedFields = changedFields.add("includeLocations");
            return this;
        }

        public Builder includeLocations(String... includeLocations) {
            return includeLocations(Arrays.asList(includeLocations));
        }

        public Builder includeLocationsNextLink(String includeLocationsNextLink) {
            this.includeLocationsNextLink = includeLocationsNextLink;
            this.changedFields = changedFields.add("includeLocations");
            return this;
        }

        public Builder excludeLocations(List<String> excludeLocations) {
            this.excludeLocations = excludeLocations;
            this.changedFields = changedFields.add("excludeLocations");
            return this;
        }

        public Builder excludeLocations(String... excludeLocations) {
            return excludeLocations(Arrays.asList(excludeLocations));
        }

        public Builder excludeLocationsNextLink(String excludeLocationsNextLink) {
            this.excludeLocationsNextLink = excludeLocationsNextLink;
            this.changedFields = changedFields.add("excludeLocations");
            return this;
        }

        public ConditionalAccessLocations build() {
            ConditionalAccessLocations _x = new ConditionalAccessLocations();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.conditionalAccessLocations";
            _x.includeLocations = includeLocations;
            _x.includeLocationsNextLink = includeLocationsNextLink;
            _x.excludeLocations = excludeLocations;
            _x.excludeLocationsNextLink = excludeLocationsNextLink;
            return _x;
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ConditionalAccessLocations[");
        b.append("includeLocations=");
        b.append(this.includeLocations);
        b.append(", ");
        b.append("excludeLocations=");
        b.append(this.excludeLocations);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
