package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.ConditionalAccessGrantControl;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "operator", 
    "builtInControls", 
    "customAuthenticationFactors", 
    "termsOfUse"})
@JsonInclude(Include.NON_NULL)
public class ConditionalAccessGrantControls implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("operator")
    protected String operator;

    @JsonProperty("builtInControls")
    protected List<ConditionalAccessGrantControl> builtInControls;

    @JsonProperty("builtInControls@nextLink")
    protected String builtInControlsNextLink;

    @JsonProperty("customAuthenticationFactors")
    protected List<String> customAuthenticationFactors;

    @JsonProperty("customAuthenticationFactors@nextLink")
    protected String customAuthenticationFactorsNextLink;

    @JsonProperty("termsOfUse")
    protected List<String> termsOfUse;

    @JsonProperty("termsOfUse@nextLink")
    protected String termsOfUseNextLink;

    protected ConditionalAccessGrantControls() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.conditionalAccessGrantControls";
    }

    @Property(name="operator")
    @JsonIgnore
    public Optional<String> getOperator() {
        return Optional.ofNullable(operator);
    }

    public ConditionalAccessGrantControls withOperator(String operator) {
        ConditionalAccessGrantControls _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.conditionalAccessGrantControls");
        _x.operator = operator;
        return _x;
    }

    @Property(name="builtInControls")
    @JsonIgnore
    public CollectionPage<ConditionalAccessGrantControl> getBuiltInControls() {
        return new CollectionPage<ConditionalAccessGrantControl>(contextPath, ConditionalAccessGrantControl.class, builtInControls, Optional.ofNullable(builtInControlsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="builtInControls")
    @JsonIgnore
    public CollectionPage<ConditionalAccessGrantControl> getBuiltInControls(HttpRequestOptions options) {
        return new CollectionPage<ConditionalAccessGrantControl>(contextPath, ConditionalAccessGrantControl.class, builtInControls, Optional.ofNullable(builtInControlsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="customAuthenticationFactors")
    @JsonIgnore
    public CollectionPage<String> getCustomAuthenticationFactors() {
        return new CollectionPage<String>(contextPath, String.class, customAuthenticationFactors, Optional.ofNullable(customAuthenticationFactorsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="customAuthenticationFactors")
    @JsonIgnore
    public CollectionPage<String> getCustomAuthenticationFactors(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, customAuthenticationFactors, Optional.ofNullable(customAuthenticationFactorsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="termsOfUse")
    @JsonIgnore
    public CollectionPage<String> getTermsOfUse() {
        return new CollectionPage<String>(contextPath, String.class, termsOfUse, Optional.ofNullable(termsOfUseNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="termsOfUse")
    @JsonIgnore
    public CollectionPage<String> getTermsOfUse(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, termsOfUse, Optional.ofNullable(termsOfUseNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String operator;
        private List<ConditionalAccessGrantControl> builtInControls;
        private String builtInControlsNextLink;
        private List<String> customAuthenticationFactors;
        private String customAuthenticationFactorsNextLink;
        private List<String> termsOfUse;
        private String termsOfUseNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder operator(String operator) {
            this.operator = operator;
            this.changedFields = changedFields.add("operator");
            return this;
        }

        public Builder builtInControls(List<ConditionalAccessGrantControl> builtInControls) {
            this.builtInControls = builtInControls;
            this.changedFields = changedFields.add("builtInControls");
            return this;
        }

        public Builder builtInControls(ConditionalAccessGrantControl... builtInControls) {
            return builtInControls(Arrays.asList(builtInControls));
        }

        public Builder builtInControlsNextLink(String builtInControlsNextLink) {
            this.builtInControlsNextLink = builtInControlsNextLink;
            this.changedFields = changedFields.add("builtInControls");
            return this;
        }

        public Builder customAuthenticationFactors(List<String> customAuthenticationFactors) {
            this.customAuthenticationFactors = customAuthenticationFactors;
            this.changedFields = changedFields.add("customAuthenticationFactors");
            return this;
        }

        public Builder customAuthenticationFactors(String... customAuthenticationFactors) {
            return customAuthenticationFactors(Arrays.asList(customAuthenticationFactors));
        }

        public Builder customAuthenticationFactorsNextLink(String customAuthenticationFactorsNextLink) {
            this.customAuthenticationFactorsNextLink = customAuthenticationFactorsNextLink;
            this.changedFields = changedFields.add("customAuthenticationFactors");
            return this;
        }

        public Builder termsOfUse(List<String> termsOfUse) {
            this.termsOfUse = termsOfUse;
            this.changedFields = changedFields.add("termsOfUse");
            return this;
        }

        public Builder termsOfUse(String... termsOfUse) {
            return termsOfUse(Arrays.asList(termsOfUse));
        }

        public Builder termsOfUseNextLink(String termsOfUseNextLink) {
            this.termsOfUseNextLink = termsOfUseNextLink;
            this.changedFields = changedFields.add("termsOfUse");
            return this;
        }

        public ConditionalAccessGrantControls build() {
            ConditionalAccessGrantControls _x = new ConditionalAccessGrantControls();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.conditionalAccessGrantControls";
            _x.operator = operator;
            _x.builtInControls = builtInControls;
            _x.builtInControlsNextLink = builtInControlsNextLink;
            _x.customAuthenticationFactors = customAuthenticationFactors;
            _x.customAuthenticationFactorsNextLink = customAuthenticationFactorsNextLink;
            _x.termsOfUse = termsOfUse;
            _x.termsOfUseNextLink = termsOfUseNextLink;
            return _x;
        }
    }

    private ConditionalAccessGrantControls _copy() {
        ConditionalAccessGrantControls _x = new ConditionalAccessGrantControls();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.operator = operator;
        _x.builtInControls = builtInControls;
        _x.customAuthenticationFactors = customAuthenticationFactors;
        _x.termsOfUse = termsOfUse;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ConditionalAccessGrantControls[");
        b.append("operator=");
        b.append(this.operator);
        b.append(", ");
        b.append("builtInControls=");
        b.append(this.builtInControls);
        b.append(", ");
        b.append("customAuthenticationFactors=");
        b.append(this.customAuthenticationFactors);
        b.append(", ");
        b.append("termsOfUse=");
        b.append(this.termsOfUse);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
