package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "includeDeviceStates", 
    "excludeDeviceStates"})
@JsonInclude(Include.NON_NULL)
public class ConditionalAccessDevices implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("includeDeviceStates")
    protected List<String> includeDeviceStates;

    @JsonProperty("includeDeviceStates@nextLink")
    protected String includeDeviceStatesNextLink;

    @JsonProperty("excludeDeviceStates")
    protected List<String> excludeDeviceStates;

    @JsonProperty("excludeDeviceStates@nextLink")
    protected String excludeDeviceStatesNextLink;

    protected ConditionalAccessDevices() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.conditionalAccessDevices";
    }

    @Property(name="includeDeviceStates")
    @JsonIgnore
    public CollectionPage<String> getIncludeDeviceStates() {
        return new CollectionPage<String>(contextPath, String.class, includeDeviceStates, Optional.ofNullable(includeDeviceStatesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="includeDeviceStates")
    @JsonIgnore
    public CollectionPage<String> getIncludeDeviceStates(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, includeDeviceStates, Optional.ofNullable(includeDeviceStatesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="excludeDeviceStates")
    @JsonIgnore
    public CollectionPage<String> getExcludeDeviceStates() {
        return new CollectionPage<String>(contextPath, String.class, excludeDeviceStates, Optional.ofNullable(excludeDeviceStatesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="excludeDeviceStates")
    @JsonIgnore
    public CollectionPage<String> getExcludeDeviceStates(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, excludeDeviceStates, Optional.ofNullable(excludeDeviceStatesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> includeDeviceStates;
        private String includeDeviceStatesNextLink;
        private List<String> excludeDeviceStates;
        private String excludeDeviceStatesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder includeDeviceStates(List<String> includeDeviceStates) {
            this.includeDeviceStates = includeDeviceStates;
            this.changedFields = changedFields.add("includeDeviceStates");
            return this;
        }

        public Builder includeDeviceStates(String... includeDeviceStates) {
            return includeDeviceStates(Arrays.asList(includeDeviceStates));
        }

        public Builder includeDeviceStatesNextLink(String includeDeviceStatesNextLink) {
            this.includeDeviceStatesNextLink = includeDeviceStatesNextLink;
            this.changedFields = changedFields.add("includeDeviceStates");
            return this;
        }

        public Builder excludeDeviceStates(List<String> excludeDeviceStates) {
            this.excludeDeviceStates = excludeDeviceStates;
            this.changedFields = changedFields.add("excludeDeviceStates");
            return this;
        }

        public Builder excludeDeviceStates(String... excludeDeviceStates) {
            return excludeDeviceStates(Arrays.asList(excludeDeviceStates));
        }

        public Builder excludeDeviceStatesNextLink(String excludeDeviceStatesNextLink) {
            this.excludeDeviceStatesNextLink = excludeDeviceStatesNextLink;
            this.changedFields = changedFields.add("excludeDeviceStates");
            return this;
        }

        public ConditionalAccessDevices build() {
            ConditionalAccessDevices _x = new ConditionalAccessDevices();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.conditionalAccessDevices";
            _x.includeDeviceStates = includeDeviceStates;
            _x.includeDeviceStatesNextLink = includeDeviceStatesNextLink;
            _x.excludeDeviceStates = excludeDeviceStates;
            _x.excludeDeviceStatesNextLink = excludeDeviceStatesNextLink;
            return _x;
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ConditionalAccessDevices[");
        b.append("includeDeviceStates=");
        b.append(this.includeDeviceStates);
        b.append(", ");
        b.append("excludeDeviceStates=");
        b.append(this.excludeDeviceStates);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
