package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "includeStates", 
    "excludeStates"})
@JsonInclude(Include.NON_NULL)
public class ConditionalAccessDeviceStates implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("includeStates")
    protected List<String> includeStates;

    @JsonProperty("includeStates@nextLink")
    protected String includeStatesNextLink;

    @JsonProperty("excludeStates")
    protected List<String> excludeStates;

    @JsonProperty("excludeStates@nextLink")
    protected String excludeStatesNextLink;

    protected ConditionalAccessDeviceStates() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.conditionalAccessDeviceStates";
    }

    @Property(name="includeStates")
    @JsonIgnore
    public CollectionPage<String> getIncludeStates() {
        return new CollectionPage<String>(contextPath, String.class, includeStates, Optional.ofNullable(includeStatesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="includeStates")
    @JsonIgnore
    public CollectionPage<String> getIncludeStates(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, includeStates, Optional.ofNullable(includeStatesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="excludeStates")
    @JsonIgnore
    public CollectionPage<String> getExcludeStates() {
        return new CollectionPage<String>(contextPath, String.class, excludeStates, Optional.ofNullable(excludeStatesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="excludeStates")
    @JsonIgnore
    public CollectionPage<String> getExcludeStates(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, excludeStates, Optional.ofNullable(excludeStatesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> includeStates;
        private String includeStatesNextLink;
        private List<String> excludeStates;
        private String excludeStatesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder includeStates(List<String> includeStates) {
            this.includeStates = includeStates;
            this.changedFields = changedFields.add("includeStates");
            return this;
        }

        public Builder includeStates(String... includeStates) {
            return includeStates(Arrays.asList(includeStates));
        }

        public Builder includeStatesNextLink(String includeStatesNextLink) {
            this.includeStatesNextLink = includeStatesNextLink;
            this.changedFields = changedFields.add("includeStates");
            return this;
        }

        public Builder excludeStates(List<String> excludeStates) {
            this.excludeStates = excludeStates;
            this.changedFields = changedFields.add("excludeStates");
            return this;
        }

        public Builder excludeStates(String... excludeStates) {
            return excludeStates(Arrays.asList(excludeStates));
        }

        public Builder excludeStatesNextLink(String excludeStatesNextLink) {
            this.excludeStatesNextLink = excludeStatesNextLink;
            this.changedFields = changedFields.add("excludeStates");
            return this;
        }

        public ConditionalAccessDeviceStates build() {
            ConditionalAccessDeviceStates _x = new ConditionalAccessDeviceStates();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.conditionalAccessDeviceStates";
            _x.includeStates = includeStates;
            _x.includeStatesNextLink = includeStatesNextLink;
            _x.excludeStates = excludeStates;
            _x.excludeStatesNextLink = excludeStatesNextLink;
            return _x;
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ConditionalAccessDeviceStates[");
        b.append("includeStates=");
        b.append(this.includeStates);
        b.append(", ");
        b.append("excludeStates=");
        b.append(this.excludeStates);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
