package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.ConditionalAccessClientApp;
import odata.msgraph.client.beta.enums.RiskLevel;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "applications", 
    "users", 
    "signInRiskLevels", 
    "userRiskLevels", 
    "platforms", 
    "locations", 
    "clientAppTypes", 
    "deviceStates", 
    "devices"})
@JsonInclude(Include.NON_NULL)
public class ConditionalAccessConditionSet implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("applications")
    protected ConditionalAccessApplications applications;

    @JsonProperty("users")
    protected ConditionalAccessUsers users;

    @JsonProperty("signInRiskLevels")
    protected List<RiskLevel> signInRiskLevels;

    @JsonProperty("signInRiskLevels@nextLink")
    protected String signInRiskLevelsNextLink;

    @JsonProperty("userRiskLevels")
    protected List<RiskLevel> userRiskLevels;

    @JsonProperty("userRiskLevels@nextLink")
    protected String userRiskLevelsNextLink;

    @JsonProperty("platforms")
    protected ConditionalAccessPlatforms platforms;

    @JsonProperty("locations")
    protected ConditionalAccessLocations locations;

    @JsonProperty("clientAppTypes")
    protected List<ConditionalAccessClientApp> clientAppTypes;

    @JsonProperty("clientAppTypes@nextLink")
    protected String clientAppTypesNextLink;

    @JsonProperty("deviceStates")
    protected ConditionalAccessDeviceStates deviceStates;

    @JsonProperty("devices")
    protected ConditionalAccessDevices devices;

    protected ConditionalAccessConditionSet() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.conditionalAccessConditionSet";
    }

    @Property(name="applications")
    @JsonIgnore
    public Optional<ConditionalAccessApplications> getApplications() {
        return Optional.ofNullable(applications);
    }

    public ConditionalAccessConditionSet withApplications(ConditionalAccessApplications applications) {
        ConditionalAccessConditionSet _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.conditionalAccessConditionSet");
        _x.applications = applications;
        return _x;
    }

    @Property(name="users")
    @JsonIgnore
    public Optional<ConditionalAccessUsers> getUsers() {
        return Optional.ofNullable(users);
    }

    public ConditionalAccessConditionSet withUsers(ConditionalAccessUsers users) {
        ConditionalAccessConditionSet _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.conditionalAccessConditionSet");
        _x.users = users;
        return _x;
    }

    @Property(name="signInRiskLevels")
    @JsonIgnore
    public CollectionPage<RiskLevel> getSignInRiskLevels() {
        return new CollectionPage<RiskLevel>(contextPath, RiskLevel.class, signInRiskLevels, Optional.ofNullable(signInRiskLevelsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="signInRiskLevels")
    @JsonIgnore
    public CollectionPage<RiskLevel> getSignInRiskLevels(HttpRequestOptions options) {
        return new CollectionPage<RiskLevel>(contextPath, RiskLevel.class, signInRiskLevels, Optional.ofNullable(signInRiskLevelsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="userRiskLevels")
    @JsonIgnore
    public CollectionPage<RiskLevel> getUserRiskLevels() {
        return new CollectionPage<RiskLevel>(contextPath, RiskLevel.class, userRiskLevels, Optional.ofNullable(userRiskLevelsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="userRiskLevels")
    @JsonIgnore
    public CollectionPage<RiskLevel> getUserRiskLevels(HttpRequestOptions options) {
        return new CollectionPage<RiskLevel>(contextPath, RiskLevel.class, userRiskLevels, Optional.ofNullable(userRiskLevelsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="platforms")
    @JsonIgnore
    public Optional<ConditionalAccessPlatforms> getPlatforms() {
        return Optional.ofNullable(platforms);
    }

    public ConditionalAccessConditionSet withPlatforms(ConditionalAccessPlatforms platforms) {
        ConditionalAccessConditionSet _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.conditionalAccessConditionSet");
        _x.platforms = platforms;
        return _x;
    }

    @Property(name="locations")
    @JsonIgnore
    public Optional<ConditionalAccessLocations> getLocations() {
        return Optional.ofNullable(locations);
    }

    public ConditionalAccessConditionSet withLocations(ConditionalAccessLocations locations) {
        ConditionalAccessConditionSet _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.conditionalAccessConditionSet");
        _x.locations = locations;
        return _x;
    }

    @Property(name="clientAppTypes")
    @JsonIgnore
    public CollectionPage<ConditionalAccessClientApp> getClientAppTypes() {
        return new CollectionPage<ConditionalAccessClientApp>(contextPath, ConditionalAccessClientApp.class, clientAppTypes, Optional.ofNullable(clientAppTypesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="clientAppTypes")
    @JsonIgnore
    public CollectionPage<ConditionalAccessClientApp> getClientAppTypes(HttpRequestOptions options) {
        return new CollectionPage<ConditionalAccessClientApp>(contextPath, ConditionalAccessClientApp.class, clientAppTypes, Optional.ofNullable(clientAppTypesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="deviceStates")
    @JsonIgnore
    public Optional<ConditionalAccessDeviceStates> getDeviceStates() {
        return Optional.ofNullable(deviceStates);
    }

    public ConditionalAccessConditionSet withDeviceStates(ConditionalAccessDeviceStates deviceStates) {
        ConditionalAccessConditionSet _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.conditionalAccessConditionSet");
        _x.deviceStates = deviceStates;
        return _x;
    }

    @Property(name="devices")
    @JsonIgnore
    public Optional<ConditionalAccessDevices> getDevices() {
        return Optional.ofNullable(devices);
    }

    public ConditionalAccessConditionSet withDevices(ConditionalAccessDevices devices) {
        ConditionalAccessConditionSet _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.conditionalAccessConditionSet");
        _x.devices = devices;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ConditionalAccessApplications applications;
        private ConditionalAccessUsers users;
        private List<RiskLevel> signInRiskLevels;
        private String signInRiskLevelsNextLink;
        private List<RiskLevel> userRiskLevels;
        private String userRiskLevelsNextLink;
        private ConditionalAccessPlatforms platforms;
        private ConditionalAccessLocations locations;
        private List<ConditionalAccessClientApp> clientAppTypes;
        private String clientAppTypesNextLink;
        private ConditionalAccessDeviceStates deviceStates;
        private ConditionalAccessDevices devices;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder applications(ConditionalAccessApplications applications) {
            this.applications = applications;
            this.changedFields = changedFields.add("applications");
            return this;
        }

        public Builder users(ConditionalAccessUsers users) {
            this.users = users;
            this.changedFields = changedFields.add("users");
            return this;
        }

        public Builder signInRiskLevels(List<RiskLevel> signInRiskLevels) {
            this.signInRiskLevels = signInRiskLevels;
            this.changedFields = changedFields.add("signInRiskLevels");
            return this;
        }

        public Builder signInRiskLevels(RiskLevel... signInRiskLevels) {
            return signInRiskLevels(Arrays.asList(signInRiskLevels));
        }

        public Builder signInRiskLevelsNextLink(String signInRiskLevelsNextLink) {
            this.signInRiskLevelsNextLink = signInRiskLevelsNextLink;
            this.changedFields = changedFields.add("signInRiskLevels");
            return this;
        }

        public Builder userRiskLevels(List<RiskLevel> userRiskLevels) {
            this.userRiskLevels = userRiskLevels;
            this.changedFields = changedFields.add("userRiskLevels");
            return this;
        }

        public Builder userRiskLevels(RiskLevel... userRiskLevels) {
            return userRiskLevels(Arrays.asList(userRiskLevels));
        }

        public Builder userRiskLevelsNextLink(String userRiskLevelsNextLink) {
            this.userRiskLevelsNextLink = userRiskLevelsNextLink;
            this.changedFields = changedFields.add("userRiskLevels");
            return this;
        }

        public Builder platforms(ConditionalAccessPlatforms platforms) {
            this.platforms = platforms;
            this.changedFields = changedFields.add("platforms");
            return this;
        }

        public Builder locations(ConditionalAccessLocations locations) {
            this.locations = locations;
            this.changedFields = changedFields.add("locations");
            return this;
        }

        public Builder clientAppTypes(List<ConditionalAccessClientApp> clientAppTypes) {
            this.clientAppTypes = clientAppTypes;
            this.changedFields = changedFields.add("clientAppTypes");
            return this;
        }

        public Builder clientAppTypes(ConditionalAccessClientApp... clientAppTypes) {
            return clientAppTypes(Arrays.asList(clientAppTypes));
        }

        public Builder clientAppTypesNextLink(String clientAppTypesNextLink) {
            this.clientAppTypesNextLink = clientAppTypesNextLink;
            this.changedFields = changedFields.add("clientAppTypes");
            return this;
        }

        public Builder deviceStates(ConditionalAccessDeviceStates deviceStates) {
            this.deviceStates = deviceStates;
            this.changedFields = changedFields.add("deviceStates");
            return this;
        }

        public Builder devices(ConditionalAccessDevices devices) {
            this.devices = devices;
            this.changedFields = changedFields.add("devices");
            return this;
        }

        public ConditionalAccessConditionSet build() {
            ConditionalAccessConditionSet _x = new ConditionalAccessConditionSet();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.conditionalAccessConditionSet";
            _x.applications = applications;
            _x.users = users;
            _x.signInRiskLevels = signInRiskLevels;
            _x.signInRiskLevelsNextLink = signInRiskLevelsNextLink;
            _x.userRiskLevels = userRiskLevels;
            _x.userRiskLevelsNextLink = userRiskLevelsNextLink;
            _x.platforms = platforms;
            _x.locations = locations;
            _x.clientAppTypes = clientAppTypes;
            _x.clientAppTypesNextLink = clientAppTypesNextLink;
            _x.deviceStates = deviceStates;
            _x.devices = devices;
            return _x;
        }
    }

    private ConditionalAccessConditionSet _copy() {
        ConditionalAccessConditionSet _x = new ConditionalAccessConditionSet();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.applications = applications;
        _x.users = users;
        _x.signInRiskLevels = signInRiskLevels;
        _x.userRiskLevels = userRiskLevels;
        _x.platforms = platforms;
        _x.locations = locations;
        _x.clientAppTypes = clientAppTypes;
        _x.deviceStates = deviceStates;
        _x.devices = devices;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ConditionalAccessConditionSet[");
        b.append("applications=");
        b.append(this.applications);
        b.append(", ");
        b.append("users=");
        b.append(this.users);
        b.append(", ");
        b.append("signInRiskLevels=");
        b.append(this.signInRiskLevels);
        b.append(", ");
        b.append("userRiskLevels=");
        b.append(this.userRiskLevels);
        b.append(", ");
        b.append("platforms=");
        b.append(this.platforms);
        b.append(", ");
        b.append("locations=");
        b.append(this.locations);
        b.append(", ");
        b.append("clientAppTypes=");
        b.append(this.clientAppTypes);
        b.append(", ");
        b.append("deviceStates=");
        b.append(this.deviceStates);
        b.append(", ");
        b.append("devices=");
        b.append(this.devices);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
