package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "includeApplications", 
    "excludeApplications", 
    "includeUserActions"})
@JsonInclude(Include.NON_NULL)
public class ConditionalAccessApplications implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("includeApplications")
    protected List<String> includeApplications;

    @JsonProperty("includeApplications@nextLink")
    protected String includeApplicationsNextLink;

    @JsonProperty("excludeApplications")
    protected List<String> excludeApplications;

    @JsonProperty("excludeApplications@nextLink")
    protected String excludeApplicationsNextLink;

    @JsonProperty("includeUserActions")
    protected List<String> includeUserActions;

    @JsonProperty("includeUserActions@nextLink")
    protected String includeUserActionsNextLink;

    protected ConditionalAccessApplications() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.conditionalAccessApplications";
    }

    @Property(name="includeApplications")
    @JsonIgnore
    public CollectionPage<String> getIncludeApplications() {
        return new CollectionPage<String>(contextPath, String.class, includeApplications, Optional.ofNullable(includeApplicationsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="includeApplications")
    @JsonIgnore
    public CollectionPage<String> getIncludeApplications(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, includeApplications, Optional.ofNullable(includeApplicationsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="excludeApplications")
    @JsonIgnore
    public CollectionPage<String> getExcludeApplications() {
        return new CollectionPage<String>(contextPath, String.class, excludeApplications, Optional.ofNullable(excludeApplicationsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="excludeApplications")
    @JsonIgnore
    public CollectionPage<String> getExcludeApplications(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, excludeApplications, Optional.ofNullable(excludeApplicationsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="includeUserActions")
    @JsonIgnore
    public CollectionPage<String> getIncludeUserActions() {
        return new CollectionPage<String>(contextPath, String.class, includeUserActions, Optional.ofNullable(includeUserActionsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="includeUserActions")
    @JsonIgnore
    public CollectionPage<String> getIncludeUserActions(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, includeUserActions, Optional.ofNullable(includeUserActionsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> includeApplications;
        private String includeApplicationsNextLink;
        private List<String> excludeApplications;
        private String excludeApplicationsNextLink;
        private List<String> includeUserActions;
        private String includeUserActionsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder includeApplications(List<String> includeApplications) {
            this.includeApplications = includeApplications;
            this.changedFields = changedFields.add("includeApplications");
            return this;
        }

        public Builder includeApplications(String... includeApplications) {
            return includeApplications(Arrays.asList(includeApplications));
        }

        public Builder includeApplicationsNextLink(String includeApplicationsNextLink) {
            this.includeApplicationsNextLink = includeApplicationsNextLink;
            this.changedFields = changedFields.add("includeApplications");
            return this;
        }

        public Builder excludeApplications(List<String> excludeApplications) {
            this.excludeApplications = excludeApplications;
            this.changedFields = changedFields.add("excludeApplications");
            return this;
        }

        public Builder excludeApplications(String... excludeApplications) {
            return excludeApplications(Arrays.asList(excludeApplications));
        }

        public Builder excludeApplicationsNextLink(String excludeApplicationsNextLink) {
            this.excludeApplicationsNextLink = excludeApplicationsNextLink;
            this.changedFields = changedFields.add("excludeApplications");
            return this;
        }

        public Builder includeUserActions(List<String> includeUserActions) {
            this.includeUserActions = includeUserActions;
            this.changedFields = changedFields.add("includeUserActions");
            return this;
        }

        public Builder includeUserActions(String... includeUserActions) {
            return includeUserActions(Arrays.asList(includeUserActions));
        }

        public Builder includeUserActionsNextLink(String includeUserActionsNextLink) {
            this.includeUserActionsNextLink = includeUserActionsNextLink;
            this.changedFields = changedFields.add("includeUserActions");
            return this;
        }

        public ConditionalAccessApplications build() {
            ConditionalAccessApplications _x = new ConditionalAccessApplications();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.conditionalAccessApplications";
            _x.includeApplications = includeApplications;
            _x.includeApplicationsNextLink = includeApplicationsNextLink;
            _x.excludeApplications = excludeApplications;
            _x.excludeApplicationsNextLink = excludeApplicationsNextLink;
            _x.includeUserActions = includeUserActions;
            _x.includeUserActionsNextLink = includeUserActionsNextLink;
            return _x;
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ConditionalAccessApplications[");
        b.append("includeApplications=");
        b.append(this.includeApplications);
        b.append(", ");
        b.append("excludeApplications=");
        b.append(this.excludeApplications);
        b.append(", ");
        b.append("includeUserActions=");
        b.append(this.includeUserActions);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
