package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.ChangeType;

@JsonPropertyOrder({
    "@odata.type", 
    "changeType", 
    "resourceUrl"})
@JsonInclude(Include.NON_NULL)
public class CommsNotification implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("changeType")
    protected ChangeType changeType;

    @JsonProperty("resourceUrl")
    protected String resourceUrl;

    protected CommsNotification() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.commsNotification";
    }

    @Property(name="changeType")
    @JsonIgnore
    public Optional<ChangeType> getChangeType() {
        return Optional.ofNullable(changeType);
    }

    public CommsNotification withChangeType(ChangeType changeType) {
        CommsNotification _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.commsNotification");
        _x.changeType = changeType;
        return _x;
    }

    @Property(name="resourceUrl")
    @JsonIgnore
    public Optional<String> getResourceUrl() {
        return Optional.ofNullable(resourceUrl);
    }

    public CommsNotification withResourceUrl(String resourceUrl) {
        CommsNotification _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.commsNotification");
        _x.resourceUrl = resourceUrl;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ChangeType changeType;
        private String resourceUrl;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder changeType(ChangeType changeType) {
            this.changeType = changeType;
            this.changedFields = changedFields.add("changeType");
            return this;
        }

        public Builder resourceUrl(String resourceUrl) {
            this.resourceUrl = resourceUrl;
            this.changedFields = changedFields.add("resourceUrl");
            return this;
        }

        public CommsNotification build() {
            CommsNotification _x = new CommsNotification();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.commsNotification";
            _x.changeType = changeType;
            _x.resourceUrl = resourceUrl;
            return _x;
        }
    }

    private CommsNotification _copy() {
        CommsNotification _x = new CommsNotification();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.changeType = changeType;
        _x.resourceUrl = resourceUrl;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CommsNotification[");
        b.append("changeType=");
        b.append(this.changeType);
        b.append(", ");
        b.append("resourceUrl=");
        b.append(this.resourceUrl);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
