package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "isReply", 
    "parentAuthor", 
    "participants"})
@JsonInclude(Include.NON_NULL)
public class CommentAction implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("isReply")
    protected Boolean isReply;

    @JsonProperty("parentAuthor")
    protected IdentitySet parentAuthor;

    @JsonProperty("participants")
    protected List<IdentitySet> participants;

    @JsonProperty("participants@nextLink")
    protected String participantsNextLink;

    protected CommentAction() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.commentAction";
    }

    @Property(name="isReply")
    @JsonIgnore
    public Optional<Boolean> getIsReply() {
        return Optional.ofNullable(isReply);
    }

    public CommentAction withIsReply(Boolean isReply) {
        CommentAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.commentAction");
        _x.isReply = isReply;
        return _x;
    }

    @Property(name="parentAuthor")
    @JsonIgnore
    public Optional<IdentitySet> getParentAuthor() {
        return Optional.ofNullable(parentAuthor);
    }

    public CommentAction withParentAuthor(IdentitySet parentAuthor) {
        CommentAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.commentAction");
        _x.parentAuthor = parentAuthor;
        return _x;
    }

    @Property(name="participants")
    @JsonIgnore
    public CollectionPage<IdentitySet> getParticipants() {
        return new CollectionPage<IdentitySet>(contextPath, IdentitySet.class, participants, Optional.ofNullable(participantsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="participants")
    @JsonIgnore
    public CollectionPage<IdentitySet> getParticipants(HttpRequestOptions options) {
        return new CollectionPage<IdentitySet>(contextPath, IdentitySet.class, participants, Optional.ofNullable(participantsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean isReply;
        private IdentitySet parentAuthor;
        private List<IdentitySet> participants;
        private String participantsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder isReply(Boolean isReply) {
            this.isReply = isReply;
            this.changedFields = changedFields.add("isReply");
            return this;
        }

        public Builder parentAuthor(IdentitySet parentAuthor) {
            this.parentAuthor = parentAuthor;
            this.changedFields = changedFields.add("parentAuthor");
            return this;
        }

        public Builder participants(List<IdentitySet> participants) {
            this.participants = participants;
            this.changedFields = changedFields.add("participants");
            return this;
        }

        public Builder participants(IdentitySet... participants) {
            return participants(Arrays.asList(participants));
        }

        public Builder participantsNextLink(String participantsNextLink) {
            this.participantsNextLink = participantsNextLink;
            this.changedFields = changedFields.add("participants");
            return this;
        }

        public CommentAction build() {
            CommentAction _x = new CommentAction();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.commentAction";
            _x.isReply = isReply;
            _x.parentAuthor = parentAuthor;
            _x.participants = participants;
            _x.participantsNextLink = participantsNextLink;
            return _x;
        }
    }

    private CommentAction _copy() {
        CommentAction _x = new CommentAction();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.isReply = isReply;
        _x.parentAuthor = parentAuthor;
        _x.participants = participants;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CommentAction[");
        b.append("isReply=");
        b.append(this.isReply);
        b.append(", ");
        b.append("parentAuthor=");
        b.append(this.parentAuthor);
        b.append(", ");
        b.append("participants=");
        b.append(this.participants);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
