package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“Summary data for co managed devices”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "inventoryCount", 
    "compliancePolicyCount", 
    "resourceAccessCount", 
    "configurationSettingsCount", 
    "windowsUpdateForBusinessCount", 
    "endpointProtectionCount", 
    "modernAppsCount", 
    "officeAppsCount"})
@JsonInclude(Include.NON_NULL)
public class ComanagedDevicesSummary implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("inventoryCount")
    protected Integer inventoryCount;

    @JsonProperty("compliancePolicyCount")
    protected Integer compliancePolicyCount;

    @JsonProperty("resourceAccessCount")
    protected Integer resourceAccessCount;

    @JsonProperty("configurationSettingsCount")
    protected Integer configurationSettingsCount;

    @JsonProperty("windowsUpdateForBusinessCount")
    protected Integer windowsUpdateForBusinessCount;

    @JsonProperty("endpointProtectionCount")
    protected Integer endpointProtectionCount;

    @JsonProperty("modernAppsCount")
    protected Integer modernAppsCount;

    @JsonProperty("officeAppsCount")
    protected Integer officeAppsCount;

    protected ComanagedDevicesSummary() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.comanagedDevicesSummary";
    }

    /**
     * <i>“Number of devices with Inventory swung-over. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property inventoryCount
     */
    @Property(name="inventoryCount")
    @JsonIgnore
    public Optional<Integer> getInventoryCount() {
        return Optional.ofNullable(inventoryCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code inventoryCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Number of devices with Inventory swung-over. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param inventoryCount
     *            new value of {@code inventoryCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code inventoryCount} field changed
     */
    public ComanagedDevicesSummary withInventoryCount(Integer inventoryCount) {
        ComanagedDevicesSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.comanagedDevicesSummary");
        _x.inventoryCount = inventoryCount;
        return _x;
    }

    /**
     * <i>“Number of devices with CompliancePolicy swung-over. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property compliancePolicyCount
     */
    @Property(name="compliancePolicyCount")
    @JsonIgnore
    public Optional<Integer> getCompliancePolicyCount() {
        return Optional.ofNullable(compliancePolicyCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * compliancePolicyCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Number of devices with CompliancePolicy swung-over. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param compliancePolicyCount
     *            new value of {@code compliancePolicyCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code compliancePolicyCount} field changed
     */
    public ComanagedDevicesSummary withCompliancePolicyCount(Integer compliancePolicyCount) {
        ComanagedDevicesSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.comanagedDevicesSummary");
        _x.compliancePolicyCount = compliancePolicyCount;
        return _x;
    }

    /**
     * <i>“Number of devices with ResourceAccess swung-over. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property resourceAccessCount
     */
    @Property(name="resourceAccessCount")
    @JsonIgnore
    public Optional<Integer> getResourceAccessCount() {
        return Optional.ofNullable(resourceAccessCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * resourceAccessCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Number of devices with ResourceAccess swung-over. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param resourceAccessCount
     *            new value of {@code resourceAccessCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code resourceAccessCount} field changed
     */
    public ComanagedDevicesSummary withResourceAccessCount(Integer resourceAccessCount) {
        ComanagedDevicesSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.comanagedDevicesSummary");
        _x.resourceAccessCount = resourceAccessCount;
        return _x;
    }

    /**
     * <i>“Number of devices with ConfigurationSettings swung-over. This property is read-
     * only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property configurationSettingsCount
     */
    @Property(name="configurationSettingsCount")
    @JsonIgnore
    public Optional<Integer> getConfigurationSettingsCount() {
        return Optional.ofNullable(configurationSettingsCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * configurationSettingsCount} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Number of devices with ConfigurationSettings swung-over. This property is read-
     * only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param configurationSettingsCount
     *            new value of {@code configurationSettingsCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code configurationSettingsCount} field changed
     */
    public ComanagedDevicesSummary withConfigurationSettingsCount(Integer configurationSettingsCount) {
        ComanagedDevicesSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.comanagedDevicesSummary");
        _x.configurationSettingsCount = configurationSettingsCount;
        return _x;
    }

    /**
     * <i>“Number of devices with WindowsUpdateForBusiness swung-over. This property is
     * read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property windowsUpdateForBusinessCount
     */
    @Property(name="windowsUpdateForBusinessCount")
    @JsonIgnore
    public Optional<Integer> getWindowsUpdateForBusinessCount() {
        return Optional.ofNullable(windowsUpdateForBusinessCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * windowsUpdateForBusinessCount} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Number of devices with WindowsUpdateForBusiness swung-over. This property is
     * read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param windowsUpdateForBusinessCount
     *            new value of {@code windowsUpdateForBusinessCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code windowsUpdateForBusinessCount} field changed
     */
    public ComanagedDevicesSummary withWindowsUpdateForBusinessCount(Integer windowsUpdateForBusinessCount) {
        ComanagedDevicesSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.comanagedDevicesSummary");
        _x.windowsUpdateForBusinessCount = windowsUpdateForBusinessCount;
        return _x;
    }

    /**
     * <i>“Number of devices with EndpointProtection swung-over. This property is read-only
     * .”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property endpointProtectionCount
     */
    @Property(name="endpointProtectionCount")
    @JsonIgnore
    public Optional<Integer> getEndpointProtectionCount() {
        return Optional.ofNullable(endpointProtectionCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * endpointProtectionCount} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Number of devices with EndpointProtection swung-over. This property is read-only
     * .”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param endpointProtectionCount
     *            new value of {@code endpointProtectionCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code endpointProtectionCount} field changed
     */
    public ComanagedDevicesSummary withEndpointProtectionCount(Integer endpointProtectionCount) {
        ComanagedDevicesSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.comanagedDevicesSummary");
        _x.endpointProtectionCount = endpointProtectionCount;
        return _x;
    }

    /**
     * <i>“Number of devices with ModernApps swung-over. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property modernAppsCount
     */
    @Property(name="modernAppsCount")
    @JsonIgnore
    public Optional<Integer> getModernAppsCount() {
        return Optional.ofNullable(modernAppsCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code modernAppsCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Number of devices with ModernApps swung-over. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param modernAppsCount
     *            new value of {@code modernAppsCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code modernAppsCount} field changed
     */
    public ComanagedDevicesSummary withModernAppsCount(Integer modernAppsCount) {
        ComanagedDevicesSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.comanagedDevicesSummary");
        _x.modernAppsCount = modernAppsCount;
        return _x;
    }

    /**
     * <i>“Number of devices with OfficeApps swung-over. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property officeAppsCount
     */
    @Property(name="officeAppsCount")
    @JsonIgnore
    public Optional<Integer> getOfficeAppsCount() {
        return Optional.ofNullable(officeAppsCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code officeAppsCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Number of devices with OfficeApps swung-over. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param officeAppsCount
     *            new value of {@code officeAppsCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code officeAppsCount} field changed
     */
    public ComanagedDevicesSummary withOfficeAppsCount(Integer officeAppsCount) {
        ComanagedDevicesSummary _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.comanagedDevicesSummary");
        _x.officeAppsCount = officeAppsCount;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer inventoryCount;
        private Integer compliancePolicyCount;
        private Integer resourceAccessCount;
        private Integer configurationSettingsCount;
        private Integer windowsUpdateForBusinessCount;
        private Integer endpointProtectionCount;
        private Integer modernAppsCount;
        private Integer officeAppsCount;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Number of devices with Inventory swung-over. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param inventoryCount
         *            value of {@code inventoryCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder inventoryCount(Integer inventoryCount) {
            this.inventoryCount = inventoryCount;
            this.changedFields = changedFields.add("inventoryCount");
            return this;
        }

        /**
         * <i>“Number of devices with CompliancePolicy swung-over. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param compliancePolicyCount
         *            value of {@code compliancePolicyCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder compliancePolicyCount(Integer compliancePolicyCount) {
            this.compliancePolicyCount = compliancePolicyCount;
            this.changedFields = changedFields.add("compliancePolicyCount");
            return this;
        }

        /**
         * <i>“Number of devices with ResourceAccess swung-over. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param resourceAccessCount
         *            value of {@code resourceAccessCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder resourceAccessCount(Integer resourceAccessCount) {
            this.resourceAccessCount = resourceAccessCount;
            this.changedFields = changedFields.add("resourceAccessCount");
            return this;
        }

        /**
         * <i>“Number of devices with ConfigurationSettings swung-over. This property is read-
         * only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param configurationSettingsCount
         *            value of {@code configurationSettingsCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder configurationSettingsCount(Integer configurationSettingsCount) {
            this.configurationSettingsCount = configurationSettingsCount;
            this.changedFields = changedFields.add("configurationSettingsCount");
            return this;
        }

        /**
         * <i>“Number of devices with WindowsUpdateForBusiness swung-over. This property is
         * read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param windowsUpdateForBusinessCount
         *            value of {@code windowsUpdateForBusinessCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder windowsUpdateForBusinessCount(Integer windowsUpdateForBusinessCount) {
            this.windowsUpdateForBusinessCount = windowsUpdateForBusinessCount;
            this.changedFields = changedFields.add("windowsUpdateForBusinessCount");
            return this;
        }

        /**
         * <i>“Number of devices with EndpointProtection swung-over. This property is read-only
         * .”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param endpointProtectionCount
         *            value of {@code endpointProtectionCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder endpointProtectionCount(Integer endpointProtectionCount) {
            this.endpointProtectionCount = endpointProtectionCount;
            this.changedFields = changedFields.add("endpointProtectionCount");
            return this;
        }

        /**
         * <i>“Number of devices with ModernApps swung-over. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param modernAppsCount
         *            value of {@code modernAppsCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder modernAppsCount(Integer modernAppsCount) {
            this.modernAppsCount = modernAppsCount;
            this.changedFields = changedFields.add("modernAppsCount");
            return this;
        }

        /**
         * <i>“Number of devices with OfficeApps swung-over. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param officeAppsCount
         *            value of {@code officeAppsCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder officeAppsCount(Integer officeAppsCount) {
            this.officeAppsCount = officeAppsCount;
            this.changedFields = changedFields.add("officeAppsCount");
            return this;
        }

        public ComanagedDevicesSummary build() {
            ComanagedDevicesSummary _x = new ComanagedDevicesSummary();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.comanagedDevicesSummary";
            _x.inventoryCount = inventoryCount;
            _x.compliancePolicyCount = compliancePolicyCount;
            _x.resourceAccessCount = resourceAccessCount;
            _x.configurationSettingsCount = configurationSettingsCount;
            _x.windowsUpdateForBusinessCount = windowsUpdateForBusinessCount;
            _x.endpointProtectionCount = endpointProtectionCount;
            _x.modernAppsCount = modernAppsCount;
            _x.officeAppsCount = officeAppsCount;
            return _x;
        }
    }

    private ComanagedDevicesSummary _copy() {
        ComanagedDevicesSummary _x = new ComanagedDevicesSummary();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.inventoryCount = inventoryCount;
        _x.compliancePolicyCount = compliancePolicyCount;
        _x.resourceAccessCount = resourceAccessCount;
        _x.configurationSettingsCount = configurationSettingsCount;
        _x.windowsUpdateForBusinessCount = windowsUpdateForBusinessCount;
        _x.endpointProtectionCount = endpointProtectionCount;
        _x.modernAppsCount = modernAppsCount;
        _x.officeAppsCount = officeAppsCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ComanagedDevicesSummary[");
        b.append("inventoryCount=");
        b.append(this.inventoryCount);
        b.append(", ");
        b.append("compliancePolicyCount=");
        b.append(this.compliancePolicyCount);
        b.append(", ");
        b.append("resourceAccessCount=");
        b.append(this.resourceAccessCount);
        b.append(", ");
        b.append("configurationSettingsCount=");
        b.append(this.configurationSettingsCount);
        b.append(", ");
        b.append("windowsUpdateForBusinessCount=");
        b.append(this.windowsUpdateForBusinessCount);
        b.append(", ");
        b.append("endpointProtectionCount=");
        b.append(this.endpointProtectionCount);
        b.append(", ");
        b.append("modernAppsCount=");
        b.append(this.modernAppsCount);
        b.append(", ");
        b.append("officeAppsCount=");
        b.append(this.officeAppsCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
