package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.ChatMessagePolicyViolationDlpActionTypes;
import odata.msgraph.client.beta.enums.ChatMessagePolicyViolationUserActionTypes;
import odata.msgraph.client.beta.enums.ChatMessagePolicyViolationVerdictDetailsTypes;

@JsonPropertyOrder({
    "@odata.type", 
    "dlpAction", 
    "justificationText", 
    "policyTip", 
    "userAction", 
    "verdictDetails"})
@JsonInclude(Include.NON_NULL)
public class ChatMessagePolicyViolation implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("dlpAction")
    protected ChatMessagePolicyViolationDlpActionTypes dlpAction;

    @JsonProperty("justificationText")
    protected String justificationText;

    @JsonProperty("policyTip")
    protected ChatMessagePolicyViolationPolicyTip policyTip;

    @JsonProperty("userAction")
    protected ChatMessagePolicyViolationUserActionTypes userAction;

    @JsonProperty("verdictDetails")
    protected ChatMessagePolicyViolationVerdictDetailsTypes verdictDetails;

    protected ChatMessagePolicyViolation() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.chatMessagePolicyViolation";
    }

    @Property(name="dlpAction")
    @JsonIgnore
    public Optional<ChatMessagePolicyViolationDlpActionTypes> getDlpAction() {
        return Optional.ofNullable(dlpAction);
    }

    public ChatMessagePolicyViolation withDlpAction(ChatMessagePolicyViolationDlpActionTypes dlpAction) {
        ChatMessagePolicyViolation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatMessagePolicyViolation");
        _x.dlpAction = dlpAction;
        return _x;
    }

    @Property(name="justificationText")
    @JsonIgnore
    public Optional<String> getJustificationText() {
        return Optional.ofNullable(justificationText);
    }

    public ChatMessagePolicyViolation withJustificationText(String justificationText) {
        ChatMessagePolicyViolation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatMessagePolicyViolation");
        _x.justificationText = justificationText;
        return _x;
    }

    @Property(name="policyTip")
    @JsonIgnore
    public Optional<ChatMessagePolicyViolationPolicyTip> getPolicyTip() {
        return Optional.ofNullable(policyTip);
    }

    public ChatMessagePolicyViolation withPolicyTip(ChatMessagePolicyViolationPolicyTip policyTip) {
        ChatMessagePolicyViolation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatMessagePolicyViolation");
        _x.policyTip = policyTip;
        return _x;
    }

    @Property(name="userAction")
    @JsonIgnore
    public Optional<ChatMessagePolicyViolationUserActionTypes> getUserAction() {
        return Optional.ofNullable(userAction);
    }

    public ChatMessagePolicyViolation withUserAction(ChatMessagePolicyViolationUserActionTypes userAction) {
        ChatMessagePolicyViolation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatMessagePolicyViolation");
        _x.userAction = userAction;
        return _x;
    }

    @Property(name="verdictDetails")
    @JsonIgnore
    public Optional<ChatMessagePolicyViolationVerdictDetailsTypes> getVerdictDetails() {
        return Optional.ofNullable(verdictDetails);
    }

    public ChatMessagePolicyViolation withVerdictDetails(ChatMessagePolicyViolationVerdictDetailsTypes verdictDetails) {
        ChatMessagePolicyViolation _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatMessagePolicyViolation");
        _x.verdictDetails = verdictDetails;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ChatMessagePolicyViolationDlpActionTypes dlpAction;
        private String justificationText;
        private ChatMessagePolicyViolationPolicyTip policyTip;
        private ChatMessagePolicyViolationUserActionTypes userAction;
        private ChatMessagePolicyViolationVerdictDetailsTypes verdictDetails;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder dlpAction(ChatMessagePolicyViolationDlpActionTypes dlpAction) {
            this.dlpAction = dlpAction;
            this.changedFields = changedFields.add("dlpAction");
            return this;
        }

        public Builder justificationText(String justificationText) {
            this.justificationText = justificationText;
            this.changedFields = changedFields.add("justificationText");
            return this;
        }

        public Builder policyTip(ChatMessagePolicyViolationPolicyTip policyTip) {
            this.policyTip = policyTip;
            this.changedFields = changedFields.add("policyTip");
            return this;
        }

        public Builder userAction(ChatMessagePolicyViolationUserActionTypes userAction) {
            this.userAction = userAction;
            this.changedFields = changedFields.add("userAction");
            return this;
        }

        public Builder verdictDetails(ChatMessagePolicyViolationVerdictDetailsTypes verdictDetails) {
            this.verdictDetails = verdictDetails;
            this.changedFields = changedFields.add("verdictDetails");
            return this;
        }

        public ChatMessagePolicyViolation build() {
            ChatMessagePolicyViolation _x = new ChatMessagePolicyViolation();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.chatMessagePolicyViolation";
            _x.dlpAction = dlpAction;
            _x.justificationText = justificationText;
            _x.policyTip = policyTip;
            _x.userAction = userAction;
            _x.verdictDetails = verdictDetails;
            return _x;
        }
    }

    private ChatMessagePolicyViolation _copy() {
        ChatMessagePolicyViolation _x = new ChatMessagePolicyViolation();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.dlpAction = dlpAction;
        _x.justificationText = justificationText;
        _x.policyTip = policyTip;
        _x.userAction = userAction;
        _x.verdictDetails = verdictDetails;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ChatMessagePolicyViolation[");
        b.append("dlpAction=");
        b.append(this.dlpAction);
        b.append(", ");
        b.append("justificationText=");
        b.append(this.justificationText);
        b.append(", ");
        b.append("policyTip=");
        b.append(this.policyTip);
        b.append(", ");
        b.append("userAction=");
        b.append(this.userAction);
        b.append(", ");
        b.append("verdictDetails=");
        b.append(this.verdictDetails);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
