package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "threadId", 
    "messageId", 
    "replyChainMessageId"})
@JsonInclude(Include.NON_NULL)
public class ChatInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("threadId")
    protected String threadId;

    @JsonProperty("messageId")
    protected String messageId;

    @JsonProperty("replyChainMessageId")
    protected String replyChainMessageId;

    protected ChatInfo() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.chatInfo";
    }

    @Property(name="threadId")
    @JsonIgnore
    public Optional<String> getThreadId() {
        return Optional.ofNullable(threadId);
    }

    public ChatInfo withThreadId(String threadId) {
        ChatInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatInfo");
        _x.threadId = threadId;
        return _x;
    }

    @Property(name="messageId")
    @JsonIgnore
    public Optional<String> getMessageId() {
        return Optional.ofNullable(messageId);
    }

    public ChatInfo withMessageId(String messageId) {
        ChatInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatInfo");
        _x.messageId = messageId;
        return _x;
    }

    @Property(name="replyChainMessageId")
    @JsonIgnore
    public Optional<String> getReplyChainMessageId() {
        return Optional.ofNullable(replyChainMessageId);
    }

    public ChatInfo withReplyChainMessageId(String replyChainMessageId) {
        ChatInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chatInfo");
        _x.replyChainMessageId = replyChainMessageId;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String threadId;
        private String messageId;
        private String replyChainMessageId;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder threadId(String threadId) {
            this.threadId = threadId;
            this.changedFields = changedFields.add("threadId");
            return this;
        }

        public Builder messageId(String messageId) {
            this.messageId = messageId;
            this.changedFields = changedFields.add("messageId");
            return this;
        }

        public Builder replyChainMessageId(String replyChainMessageId) {
            this.replyChainMessageId = replyChainMessageId;
            this.changedFields = changedFields.add("replyChainMessageId");
            return this;
        }

        public ChatInfo build() {
            ChatInfo _x = new ChatInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.chatInfo";
            _x.threadId = threadId;
            _x.messageId = messageId;
            _x.replyChainMessageId = replyChainMessageId;
            return _x;
        }
    }

    private ChatInfo _copy() {
        ChatInfo _x = new ChatInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.threadId = threadId;
        _x.messageId = messageId;
        _x.replyChainMessageId = replyChainMessageId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ChatInfo[");
        b.append("threadId=");
        b.append(this.threadId);
        b.append(", ");
        b.append("messageId=");
        b.append(this.messageId);
        b.append(", ");
        b.append("replyChainMessageId=");
        b.append(this.replyChainMessageId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
