package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.ReplyRestriction;
import odata.msgraph.client.beta.enums.UserNewMessageRestriction;

@JsonPropertyOrder({
    "@odata.type", 
    "userNewMessageRestriction", 
    "replyRestriction", 
    "allowNewMessageFromBots", 
    "allowNewMessageFromConnectors"})
@JsonInclude(Include.NON_NULL)
public class ChannelModerationSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("userNewMessageRestriction")
    protected UserNewMessageRestriction userNewMessageRestriction;

    @JsonProperty("replyRestriction")
    protected ReplyRestriction replyRestriction;

    @JsonProperty("allowNewMessageFromBots")
    protected Boolean allowNewMessageFromBots;

    @JsonProperty("allowNewMessageFromConnectors")
    protected Boolean allowNewMessageFromConnectors;

    protected ChannelModerationSettings() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.channelModerationSettings";
    }

    @Property(name="userNewMessageRestriction")
    @JsonIgnore
    public Optional<UserNewMessageRestriction> getUserNewMessageRestriction() {
        return Optional.ofNullable(userNewMessageRestriction);
    }

    public ChannelModerationSettings withUserNewMessageRestriction(UserNewMessageRestriction userNewMessageRestriction) {
        ChannelModerationSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.channelModerationSettings");
        _x.userNewMessageRestriction = userNewMessageRestriction;
        return _x;
    }

    @Property(name="replyRestriction")
    @JsonIgnore
    public Optional<ReplyRestriction> getReplyRestriction() {
        return Optional.ofNullable(replyRestriction);
    }

    public ChannelModerationSettings withReplyRestriction(ReplyRestriction replyRestriction) {
        ChannelModerationSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.channelModerationSettings");
        _x.replyRestriction = replyRestriction;
        return _x;
    }

    @Property(name="allowNewMessageFromBots")
    @JsonIgnore
    public Optional<Boolean> getAllowNewMessageFromBots() {
        return Optional.ofNullable(allowNewMessageFromBots);
    }

    public ChannelModerationSettings withAllowNewMessageFromBots(Boolean allowNewMessageFromBots) {
        ChannelModerationSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.channelModerationSettings");
        _x.allowNewMessageFromBots = allowNewMessageFromBots;
        return _x;
    }

    @Property(name="allowNewMessageFromConnectors")
    @JsonIgnore
    public Optional<Boolean> getAllowNewMessageFromConnectors() {
        return Optional.ofNullable(allowNewMessageFromConnectors);
    }

    public ChannelModerationSettings withAllowNewMessageFromConnectors(Boolean allowNewMessageFromConnectors) {
        ChannelModerationSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.channelModerationSettings");
        _x.allowNewMessageFromConnectors = allowNewMessageFromConnectors;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private UserNewMessageRestriction userNewMessageRestriction;
        private ReplyRestriction replyRestriction;
        private Boolean allowNewMessageFromBots;
        private Boolean allowNewMessageFromConnectors;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder userNewMessageRestriction(UserNewMessageRestriction userNewMessageRestriction) {
            this.userNewMessageRestriction = userNewMessageRestriction;
            this.changedFields = changedFields.add("userNewMessageRestriction");
            return this;
        }

        public Builder replyRestriction(ReplyRestriction replyRestriction) {
            this.replyRestriction = replyRestriction;
            this.changedFields = changedFields.add("replyRestriction");
            return this;
        }

        public Builder allowNewMessageFromBots(Boolean allowNewMessageFromBots) {
            this.allowNewMessageFromBots = allowNewMessageFromBots;
            this.changedFields = changedFields.add("allowNewMessageFromBots");
            return this;
        }

        public Builder allowNewMessageFromConnectors(Boolean allowNewMessageFromConnectors) {
            this.allowNewMessageFromConnectors = allowNewMessageFromConnectors;
            this.changedFields = changedFields.add("allowNewMessageFromConnectors");
            return this;
        }

        public ChannelModerationSettings build() {
            ChannelModerationSettings _x = new ChannelModerationSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.channelModerationSettings";
            _x.userNewMessageRestriction = userNewMessageRestriction;
            _x.replyRestriction = replyRestriction;
            _x.allowNewMessageFromBots = allowNewMessageFromBots;
            _x.allowNewMessageFromConnectors = allowNewMessageFromConnectors;
            return _x;
        }
    }

    private ChannelModerationSettings _copy() {
        ChannelModerationSettings _x = new ChannelModerationSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.userNewMessageRestriction = userNewMessageRestriction;
        _x.replyRestriction = replyRestriction;
        _x.allowNewMessageFromBots = allowNewMessageFromBots;
        _x.allowNewMessageFromConnectors = allowNewMessageFromConnectors;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ChannelModerationSettings[");
        b.append("userNewMessageRestriction=");
        b.append(this.userNewMessageRestriction);
        b.append(", ");
        b.append("replyRestriction=");
        b.append(this.replyRestriction);
        b.append(", ");
        b.append("allowNewMessageFromBots=");
        b.append(this.allowNewMessageFromBots);
        b.append(", ");
        b.append("allowNewMessageFromConnectors=");
        b.append(this.allowNewMessageFromConnectors);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
