package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "validationTokens", 
    "value"})
@JsonInclude(Include.NON_NULL)
public class ChangeNotificationCollection implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("validationTokens")
    protected List<String> validationTokens;

    @JsonProperty("validationTokens@nextLink")
    protected String validationTokensNextLink;

    @JsonProperty("value")
    protected List<ChangeNotification> value;

    @JsonProperty("value@nextLink")
    protected String valueNextLink;

    protected ChangeNotificationCollection() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.changeNotificationCollection";
    }

    @Property(name="validationTokens")
    @JsonIgnore
    public CollectionPage<String> getValidationTokens() {
        return new CollectionPage<String>(contextPath, String.class, validationTokens, Optional.ofNullable(validationTokensNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="validationTokens")
    @JsonIgnore
    public CollectionPage<String> getValidationTokens(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, validationTokens, Optional.ofNullable(validationTokensNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="value")
    @JsonIgnore
    public CollectionPage<ChangeNotification> getValue() {
        return new CollectionPage<ChangeNotification>(contextPath, ChangeNotification.class, value, Optional.ofNullable(valueNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="value")
    @JsonIgnore
    public CollectionPage<ChangeNotification> getValue(HttpRequestOptions options) {
        return new CollectionPage<ChangeNotification>(contextPath, ChangeNotification.class, value, Optional.ofNullable(valueNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> validationTokens;
        private String validationTokensNextLink;
        private List<ChangeNotification> value;
        private String valueNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder validationTokens(List<String> validationTokens) {
            this.validationTokens = validationTokens;
            this.changedFields = changedFields.add("validationTokens");
            return this;
        }

        public Builder validationTokens(String... validationTokens) {
            return validationTokens(Arrays.asList(validationTokens));
        }

        public Builder validationTokensNextLink(String validationTokensNextLink) {
            this.validationTokensNextLink = validationTokensNextLink;
            this.changedFields = changedFields.add("validationTokens");
            return this;
        }

        public Builder value(List<ChangeNotification> value) {
            this.value = value;
            this.changedFields = changedFields.add("value");
            return this;
        }

        public Builder value(ChangeNotification... value) {
            return value(Arrays.asList(value));
        }

        public Builder valueNextLink(String valueNextLink) {
            this.valueNextLink = valueNextLink;
            this.changedFields = changedFields.add("value");
            return this;
        }

        public ChangeNotificationCollection build() {
            ChangeNotificationCollection _x = new ChangeNotificationCollection();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.changeNotificationCollection";
            _x.validationTokens = validationTokens;
            _x.validationTokensNextLink = validationTokensNextLink;
            _x.value = value;
            _x.valueNextLink = valueNextLink;
            return _x;
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ChangeNotificationCollection[");
        b.append("validationTokens=");
        b.append(this.validationTokens);
        b.append(", ");
        b.append("value=");
        b.append(this.value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
