package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.ChangeType;
import odata.msgraph.client.beta.enums.LifecycleEventType;

@JsonPropertyOrder({
    "@odata.type", 
    "id", 
    "subscriptionId", 
    "subscriptionExpirationDateTime", 
    "clientState", 
    "changeType", 
    "resource", 
    "tenantId", 
    "encryptedContent", 
    "lifecycleEvent", 
    "resourceData"})
@JsonInclude(Include.NON_NULL)
public class ChangeNotification implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("id")
    protected String id;

    @JsonProperty("subscriptionId")
    protected String subscriptionId;

    @JsonProperty("subscriptionExpirationDateTime")
    protected OffsetDateTime subscriptionExpirationDateTime;

    @JsonProperty("clientState")
    protected String clientState;

    @JsonProperty("changeType")
    protected ChangeType changeType;

    @JsonProperty("resource")
    protected String resource;

    @JsonProperty("tenantId")
    protected String tenantId;

    @JsonProperty("encryptedContent")
    protected ChangeNotificationEncryptedContent encryptedContent;

    @JsonProperty("lifecycleEvent")
    protected LifecycleEventType lifecycleEvent;

    @JsonProperty("resourceData")
    protected ResourceData resourceData;

    protected ChangeNotification() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.changeNotification";
    }

    @Property(name="id")
    @JsonIgnore
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    public ChangeNotification withId(String id) {
        ChangeNotification _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.changeNotification");
        _x.id = id;
        return _x;
    }

    @Property(name="subscriptionId")
    @JsonIgnore
    public Optional<String> getSubscriptionId() {
        return Optional.ofNullable(subscriptionId);
    }

    public ChangeNotification withSubscriptionId(String subscriptionId) {
        ChangeNotification _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.changeNotification");
        _x.subscriptionId = subscriptionId;
        return _x;
    }

    @Property(name="subscriptionExpirationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getSubscriptionExpirationDateTime() {
        return Optional.ofNullable(subscriptionExpirationDateTime);
    }

    public ChangeNotification withSubscriptionExpirationDateTime(OffsetDateTime subscriptionExpirationDateTime) {
        ChangeNotification _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.changeNotification");
        _x.subscriptionExpirationDateTime = subscriptionExpirationDateTime;
        return _x;
    }

    @Property(name="clientState")
    @JsonIgnore
    public Optional<String> getClientState() {
        return Optional.ofNullable(clientState);
    }

    public ChangeNotification withClientState(String clientState) {
        ChangeNotification _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.changeNotification");
        _x.clientState = clientState;
        return _x;
    }

    @Property(name="changeType")
    @JsonIgnore
    public Optional<ChangeType> getChangeType() {
        return Optional.ofNullable(changeType);
    }

    public ChangeNotification withChangeType(ChangeType changeType) {
        ChangeNotification _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.changeNotification");
        _x.changeType = changeType;
        return _x;
    }

    @Property(name="resource")
    @JsonIgnore
    public Optional<String> getResource() {
        return Optional.ofNullable(resource);
    }

    public ChangeNotification withResource(String resource) {
        ChangeNotification _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.changeNotification");
        _x.resource = resource;
        return _x;
    }

    @Property(name="tenantId")
    @JsonIgnore
    public Optional<String> getTenantId() {
        return Optional.ofNullable(tenantId);
    }

    public ChangeNotification withTenantId(String tenantId) {
        ChangeNotification _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.changeNotification");
        _x.tenantId = tenantId;
        return _x;
    }

    @Property(name="encryptedContent")
    @JsonIgnore
    public Optional<ChangeNotificationEncryptedContent> getEncryptedContent() {
        return Optional.ofNullable(encryptedContent);
    }

    public ChangeNotification withEncryptedContent(ChangeNotificationEncryptedContent encryptedContent) {
        ChangeNotification _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.changeNotification");
        _x.encryptedContent = encryptedContent;
        return _x;
    }

    @Property(name="lifecycleEvent")
    @JsonIgnore
    public Optional<LifecycleEventType> getLifecycleEvent() {
        return Optional.ofNullable(lifecycleEvent);
    }

    public ChangeNotification withLifecycleEvent(LifecycleEventType lifecycleEvent) {
        ChangeNotification _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.changeNotification");
        _x.lifecycleEvent = lifecycleEvent;
        return _x;
    }

    @Property(name="resourceData")
    @JsonIgnore
    public Optional<ResourceData> getResourceData() {
        return Optional.ofNullable(resourceData);
    }

    public ChangeNotification withResourceData(ResourceData resourceData) {
        ChangeNotification _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.changeNotification");
        _x.resourceData = resourceData;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String subscriptionId;
        private OffsetDateTime subscriptionExpirationDateTime;
        private String clientState;
        private ChangeType changeType;
        private String resource;
        private String tenantId;
        private ChangeNotificationEncryptedContent encryptedContent;
        private LifecycleEventType lifecycleEvent;
        private ResourceData resourceData;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            this.changedFields = changedFields.add("subscriptionId");
            return this;
        }

        public Builder subscriptionExpirationDateTime(OffsetDateTime subscriptionExpirationDateTime) {
            this.subscriptionExpirationDateTime = subscriptionExpirationDateTime;
            this.changedFields = changedFields.add("subscriptionExpirationDateTime");
            return this;
        }

        public Builder clientState(String clientState) {
            this.clientState = clientState;
            this.changedFields = changedFields.add("clientState");
            return this;
        }

        public Builder changeType(ChangeType changeType) {
            this.changeType = changeType;
            this.changedFields = changedFields.add("changeType");
            return this;
        }

        public Builder resource(String resource) {
            this.resource = resource;
            this.changedFields = changedFields.add("resource");
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            this.changedFields = changedFields.add("tenantId");
            return this;
        }

        public Builder encryptedContent(ChangeNotificationEncryptedContent encryptedContent) {
            this.encryptedContent = encryptedContent;
            this.changedFields = changedFields.add("encryptedContent");
            return this;
        }

        public Builder lifecycleEvent(LifecycleEventType lifecycleEvent) {
            this.lifecycleEvent = lifecycleEvent;
            this.changedFields = changedFields.add("lifecycleEvent");
            return this;
        }

        public Builder resourceData(ResourceData resourceData) {
            this.resourceData = resourceData;
            this.changedFields = changedFields.add("resourceData");
            return this;
        }

        public ChangeNotification build() {
            ChangeNotification _x = new ChangeNotification();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.changeNotification";
            _x.id = id;
            _x.subscriptionId = subscriptionId;
            _x.subscriptionExpirationDateTime = subscriptionExpirationDateTime;
            _x.clientState = clientState;
            _x.changeType = changeType;
            _x.resource = resource;
            _x.tenantId = tenantId;
            _x.encryptedContent = encryptedContent;
            _x.lifecycleEvent = lifecycleEvent;
            _x.resourceData = resourceData;
            return _x;
        }
    }

    private ChangeNotification _copy() {
        ChangeNotification _x = new ChangeNotification();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.subscriptionId = subscriptionId;
        _x.subscriptionExpirationDateTime = subscriptionExpirationDateTime;
        _x.clientState = clientState;
        _x.changeType = changeType;
        _x.resource = resource;
        _x.tenantId = tenantId;
        _x.encryptedContent = encryptedContent;
        _x.lifecycleEvent = lifecycleEvent;
        _x.resourceData = resourceData;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ChangeNotification[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("subscriptionId=");
        b.append(this.subscriptionId);
        b.append(", ");
        b.append("subscriptionExpirationDateTime=");
        b.append(this.subscriptionExpirationDateTime);
        b.append(", ");
        b.append("clientState=");
        b.append(this.clientState);
        b.append(", ");
        b.append("changeType=");
        b.append(this.changeType);
        b.append(", ");
        b.append("resource=");
        b.append(this.resource);
        b.append(", ");
        b.append("tenantId=");
        b.append(this.tenantId);
        b.append(", ");
        b.append("encryptedContent=");
        b.append(this.encryptedContent);
        b.append(", ");
        b.append("lifecycleEvent=");
        b.append(this.lifecycleEvent);
        b.append(", ");
        b.append("resourceData=");
        b.append(this.resourceData);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
