package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.CalendarSharingAction;
import odata.msgraph.client.beta.enums.CalendarSharingActionImportance;
import odata.msgraph.client.beta.enums.CalendarSharingActionType;

@JsonPropertyOrder({
    "@odata.type", 
    "importance", 
    "actionType", 
    "action"})
@JsonInclude(Include.NON_NULL)
public class CalendarSharingMessageAction implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("importance")
    protected CalendarSharingActionImportance importance;

    @JsonProperty("actionType")
    protected CalendarSharingActionType actionType;

    @JsonProperty("action")
    protected CalendarSharingAction action;

    protected CalendarSharingMessageAction() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.calendarSharingMessageAction";
    }

    @Property(name="importance")
    @JsonIgnore
    public Optional<CalendarSharingActionImportance> getImportance() {
        return Optional.ofNullable(importance);
    }

    public CalendarSharingMessageAction withImportance(CalendarSharingActionImportance importance) {
        CalendarSharingMessageAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.calendarSharingMessageAction");
        _x.importance = importance;
        return _x;
    }

    @Property(name="actionType")
    @JsonIgnore
    public Optional<CalendarSharingActionType> getActionType() {
        return Optional.ofNullable(actionType);
    }

    public CalendarSharingMessageAction withActionType(CalendarSharingActionType actionType) {
        CalendarSharingMessageAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.calendarSharingMessageAction");
        _x.actionType = actionType;
        return _x;
    }

    @Property(name="action")
    @JsonIgnore
    public Optional<CalendarSharingAction> getAction() {
        return Optional.ofNullable(action);
    }

    public CalendarSharingMessageAction withAction(CalendarSharingAction action) {
        CalendarSharingMessageAction _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.calendarSharingMessageAction");
        _x.action = action;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private CalendarSharingActionImportance importance;
        private CalendarSharingActionType actionType;
        private CalendarSharingAction action;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder importance(CalendarSharingActionImportance importance) {
            this.importance = importance;
            this.changedFields = changedFields.add("importance");
            return this;
        }

        public Builder actionType(CalendarSharingActionType actionType) {
            this.actionType = actionType;
            this.changedFields = changedFields.add("actionType");
            return this;
        }

        public Builder action(CalendarSharingAction action) {
            this.action = action;
            this.changedFields = changedFields.add("action");
            return this;
        }

        public CalendarSharingMessageAction build() {
            CalendarSharingMessageAction _x = new CalendarSharingMessageAction();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.calendarSharingMessageAction";
            _x.importance = importance;
            _x.actionType = actionType;
            _x.action = action;
            return _x;
        }
    }

    private CalendarSharingMessageAction _copy() {
        CalendarSharingMessageAction _x = new CalendarSharingMessageAction();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.importance = importance;
        _x.actionType = actionType;
        _x.action = action;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CalendarSharingMessageAction[");
        b.append("importance=");
        b.append(this.importance);
        b.append(", ");
        b.append("actionType=");
        b.append(this.actionType);
        b.append(", ");
        b.append("action=");
        b.append(this.action);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
