package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "successfulDeviceIds", 
    "failedDeviceIds", 
    "notFoundDeviceIds", 
    "notSupportedDeviceIds"})
@JsonInclude(Include.NON_NULL)
public class BulkManagedDeviceActionResult implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("successfulDeviceIds")
    protected List<String> successfulDeviceIds;

    @JsonProperty("successfulDeviceIds@nextLink")
    protected String successfulDeviceIdsNextLink;

    @JsonProperty("failedDeviceIds")
    protected List<String> failedDeviceIds;

    @JsonProperty("failedDeviceIds@nextLink")
    protected String failedDeviceIdsNextLink;

    @JsonProperty("notFoundDeviceIds")
    protected List<String> notFoundDeviceIds;

    @JsonProperty("notFoundDeviceIds@nextLink")
    protected String notFoundDeviceIdsNextLink;

    @JsonProperty("notSupportedDeviceIds")
    protected List<String> notSupportedDeviceIds;

    @JsonProperty("notSupportedDeviceIds@nextLink")
    protected String notSupportedDeviceIdsNextLink;

    protected BulkManagedDeviceActionResult() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.bulkManagedDeviceActionResult";
    }

    /**
     * <i>“Successful devices”</i>
     * 
     * @return property successfulDeviceIds
     */
    @Property(name="successfulDeviceIds")
    @JsonIgnore
    public CollectionPage<String> getSuccessfulDeviceIds() {
        return new CollectionPage<String>(contextPath, String.class, successfulDeviceIds, Optional.ofNullable(successfulDeviceIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Successful devices”</i>
     * 
     * @return property successfulDeviceIds
     */
    @Property(name="successfulDeviceIds")
    @JsonIgnore
    public CollectionPage<String> getSuccessfulDeviceIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, successfulDeviceIds, Optional.ofNullable(successfulDeviceIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Failed devices”</i>
     * 
     * @return property failedDeviceIds
     */
    @Property(name="failedDeviceIds")
    @JsonIgnore
    public CollectionPage<String> getFailedDeviceIds() {
        return new CollectionPage<String>(contextPath, String.class, failedDeviceIds, Optional.ofNullable(failedDeviceIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Failed devices”</i>
     * 
     * @return property failedDeviceIds
     */
    @Property(name="failedDeviceIds")
    @JsonIgnore
    public CollectionPage<String> getFailedDeviceIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, failedDeviceIds, Optional.ofNullable(failedDeviceIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Not found devices”</i>
     * 
     * @return property notFoundDeviceIds
     */
    @Property(name="notFoundDeviceIds")
    @JsonIgnore
    public CollectionPage<String> getNotFoundDeviceIds() {
        return new CollectionPage<String>(contextPath, String.class, notFoundDeviceIds, Optional.ofNullable(notFoundDeviceIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Not found devices”</i>
     * 
     * @return property notFoundDeviceIds
     */
    @Property(name="notFoundDeviceIds")
    @JsonIgnore
    public CollectionPage<String> getNotFoundDeviceIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, notFoundDeviceIds, Optional.ofNullable(notFoundDeviceIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Not supported devices”</i>
     * 
     * @return property notSupportedDeviceIds
     */
    @Property(name="notSupportedDeviceIds")
    @JsonIgnore
    public CollectionPage<String> getNotSupportedDeviceIds() {
        return new CollectionPage<String>(contextPath, String.class, notSupportedDeviceIds, Optional.ofNullable(notSupportedDeviceIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Not supported devices”</i>
     * 
     * @return property notSupportedDeviceIds
     */
    @Property(name="notSupportedDeviceIds")
    @JsonIgnore
    public CollectionPage<String> getNotSupportedDeviceIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, notSupportedDeviceIds, Optional.ofNullable(notSupportedDeviceIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> successfulDeviceIds;
        private String successfulDeviceIdsNextLink;
        private List<String> failedDeviceIds;
        private String failedDeviceIdsNextLink;
        private List<String> notFoundDeviceIds;
        private String notFoundDeviceIdsNextLink;
        private List<String> notSupportedDeviceIds;
        private String notSupportedDeviceIdsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Successful devices”</i>
         * 
         * @param successfulDeviceIds
         *            value of {@code successfulDeviceIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder successfulDeviceIds(List<String> successfulDeviceIds) {
            this.successfulDeviceIds = successfulDeviceIds;
            this.changedFields = changedFields.add("successfulDeviceIds");
            return this;
        }

        /**
         * <i>“Successful devices”</i>
         * 
         * @param successfulDeviceIds
         *            value of {@code successfulDeviceIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder successfulDeviceIds(String... successfulDeviceIds) {
            return successfulDeviceIds(Arrays.asList(successfulDeviceIds));
        }

        /**
         * <i>“Successful devices”</i>
         * 
         * @param successfulDeviceIdsNextLink
         *            value of {@code successfulDeviceIds@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder successfulDeviceIdsNextLink(String successfulDeviceIdsNextLink) {
            this.successfulDeviceIdsNextLink = successfulDeviceIdsNextLink;
            this.changedFields = changedFields.add("successfulDeviceIds");
            return this;
        }

        /**
         * <i>“Failed devices”</i>
         * 
         * @param failedDeviceIds
         *            value of {@code failedDeviceIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder failedDeviceIds(List<String> failedDeviceIds) {
            this.failedDeviceIds = failedDeviceIds;
            this.changedFields = changedFields.add("failedDeviceIds");
            return this;
        }

        /**
         * <i>“Failed devices”</i>
         * 
         * @param failedDeviceIds
         *            value of {@code failedDeviceIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder failedDeviceIds(String... failedDeviceIds) {
            return failedDeviceIds(Arrays.asList(failedDeviceIds));
        }

        /**
         * <i>“Failed devices”</i>
         * 
         * @param failedDeviceIdsNextLink
         *            value of {@code failedDeviceIds@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder failedDeviceIdsNextLink(String failedDeviceIdsNextLink) {
            this.failedDeviceIdsNextLink = failedDeviceIdsNextLink;
            this.changedFields = changedFields.add("failedDeviceIds");
            return this;
        }

        /**
         * <i>“Not found devices”</i>
         * 
         * @param notFoundDeviceIds
         *            value of {@code notFoundDeviceIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder notFoundDeviceIds(List<String> notFoundDeviceIds) {
            this.notFoundDeviceIds = notFoundDeviceIds;
            this.changedFields = changedFields.add("notFoundDeviceIds");
            return this;
        }

        /**
         * <i>“Not found devices”</i>
         * 
         * @param notFoundDeviceIds
         *            value of {@code notFoundDeviceIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder notFoundDeviceIds(String... notFoundDeviceIds) {
            return notFoundDeviceIds(Arrays.asList(notFoundDeviceIds));
        }

        /**
         * <i>“Not found devices”</i>
         * 
         * @param notFoundDeviceIdsNextLink
         *            value of {@code notFoundDeviceIds@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder notFoundDeviceIdsNextLink(String notFoundDeviceIdsNextLink) {
            this.notFoundDeviceIdsNextLink = notFoundDeviceIdsNextLink;
            this.changedFields = changedFields.add("notFoundDeviceIds");
            return this;
        }

        /**
         * <i>“Not supported devices”</i>
         * 
         * @param notSupportedDeviceIds
         *            value of {@code notSupportedDeviceIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder notSupportedDeviceIds(List<String> notSupportedDeviceIds) {
            this.notSupportedDeviceIds = notSupportedDeviceIds;
            this.changedFields = changedFields.add("notSupportedDeviceIds");
            return this;
        }

        /**
         * <i>“Not supported devices”</i>
         * 
         * @param notSupportedDeviceIds
         *            value of {@code notSupportedDeviceIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder notSupportedDeviceIds(String... notSupportedDeviceIds) {
            return notSupportedDeviceIds(Arrays.asList(notSupportedDeviceIds));
        }

        /**
         * <i>“Not supported devices”</i>
         * 
         * @param notSupportedDeviceIdsNextLink
         *            value of {@code notSupportedDeviceIds@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder notSupportedDeviceIdsNextLink(String notSupportedDeviceIdsNextLink) {
            this.notSupportedDeviceIdsNextLink = notSupportedDeviceIdsNextLink;
            this.changedFields = changedFields.add("notSupportedDeviceIds");
            return this;
        }

        public BulkManagedDeviceActionResult build() {
            BulkManagedDeviceActionResult _x = new BulkManagedDeviceActionResult();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.bulkManagedDeviceActionResult";
            _x.successfulDeviceIds = successfulDeviceIds;
            _x.successfulDeviceIdsNextLink = successfulDeviceIdsNextLink;
            _x.failedDeviceIds = failedDeviceIds;
            _x.failedDeviceIdsNextLink = failedDeviceIdsNextLink;
            _x.notFoundDeviceIds = notFoundDeviceIds;
            _x.notFoundDeviceIdsNextLink = notFoundDeviceIdsNextLink;
            _x.notSupportedDeviceIds = notSupportedDeviceIds;
            _x.notSupportedDeviceIdsNextLink = notSupportedDeviceIdsNextLink;
            return _x;
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("BulkManagedDeviceActionResult[");
        b.append("successfulDeviceIds=");
        b.append(this.successfulDeviceIds);
        b.append(", ");
        b.append("failedDeviceIds=");
        b.append(this.failedDeviceIds);
        b.append(", ");
        b.append("notFoundDeviceIds=");
        b.append(this.notFoundDeviceIds);
        b.append(", ");
        b.append("notSupportedDeviceIds=");
        b.append(this.notSupportedDeviceIds);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
