package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.DayOfWeek;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“This type represents the set of working hours in a single day of the week.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "day", 
    "timeSlots"})
@JsonInclude(Include.NON_NULL)
public class BookingWorkHours implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("day")
    protected DayOfWeek day;

    @JsonProperty("timeSlots")
    protected List<BookingWorkTimeSlot> timeSlots;

    @JsonProperty("timeSlots@nextLink")
    protected String timeSlotsNextLink;

    protected BookingWorkHours() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.bookingWorkHours";
    }

    /**
     * <i>“The day of the week represented by this instance.”</i>
     * 
     * @return property day
     */
    @Property(name="day")
    @JsonIgnore
    public Optional<DayOfWeek> getDay() {
        return Optional.ofNullable(day);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code day} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The day of the week represented by this instance.”</i>
     * 
     * @param day
     *            new value of {@code day} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code day} field changed
     */
    public BookingWorkHours withDay(DayOfWeek day) {
        BookingWorkHours _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingWorkHours");
        _x.day = day;
        return _x;
    }

    /**
     * <i>“A list of start/end times during a day.”</i>
     * 
     * @return property timeSlots
     */
    @Property(name="timeSlots")
    @JsonIgnore
    public CollectionPage<BookingWorkTimeSlot> getTimeSlots() {
        return new CollectionPage<BookingWorkTimeSlot>(contextPath, BookingWorkTimeSlot.class, timeSlots, Optional.ofNullable(timeSlotsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“A list of start/end times during a day.”</i>
     * 
     * @return property timeSlots
     */
    @Property(name="timeSlots")
    @JsonIgnore
    public CollectionPage<BookingWorkTimeSlot> getTimeSlots(HttpRequestOptions options) {
        return new CollectionPage<BookingWorkTimeSlot>(contextPath, BookingWorkTimeSlot.class, timeSlots, Optional.ofNullable(timeSlotsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private DayOfWeek day;
        private List<BookingWorkTimeSlot> timeSlots;
        private String timeSlotsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The day of the week represented by this instance.”</i>
         * 
         * @param day
         *            value of {@code day} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder day(DayOfWeek day) {
            this.day = day;
            this.changedFields = changedFields.add("day");
            return this;
        }

        /**
         * <i>“A list of start/end times during a day.”</i>
         * 
         * @param timeSlots
         *            value of {@code timeSlots} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder timeSlots(List<BookingWorkTimeSlot> timeSlots) {
            this.timeSlots = timeSlots;
            this.changedFields = changedFields.add("timeSlots");
            return this;
        }

        /**
         * <i>“A list of start/end times during a day.”</i>
         * 
         * @param timeSlots
         *            value of {@code timeSlots} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder timeSlots(BookingWorkTimeSlot... timeSlots) {
            return timeSlots(Arrays.asList(timeSlots));
        }

        /**
         * <i>“A list of start/end times during a day.”</i>
         * 
         * @param timeSlotsNextLink
         *            value of {@code timeSlots@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder timeSlotsNextLink(String timeSlotsNextLink) {
            this.timeSlotsNextLink = timeSlotsNextLink;
            this.changedFields = changedFields.add("timeSlots");
            return this;
        }

        public BookingWorkHours build() {
            BookingWorkHours _x = new BookingWorkHours();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.bookingWorkHours";
            _x.day = day;
            _x.timeSlots = timeSlots;
            _x.timeSlotsNextLink = timeSlotsNextLink;
            return _x;
        }
    }

    private BookingWorkHours _copy() {
        BookingWorkHours _x = new BookingWorkHours();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.day = day;
        _x.timeSlots = timeSlots;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("BookingWorkHours[");
        b.append("day=");
        b.append(this.day);
        b.append(", ");
        b.append("timeSlots=");
        b.append(this.timeSlots);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
