package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.Duration;
import java.util.Optional;


/**
 * <i>“This type represents the set of policies that dictate how bookings can be
 * created in a Booking Calendar.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "timeSlotInterval", 
    "minimumLeadTime", 
    "maximumAdvance", 
    "sendConfirmationsToOwner", 
    "allowStaffSelection"})
@JsonInclude(Include.NON_NULL)
public class BookingSchedulingPolicy implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("timeSlotInterval")
    protected Duration timeSlotInterval;

    @JsonProperty("minimumLeadTime")
    protected Duration minimumLeadTime;

    @JsonProperty("maximumAdvance")
    protected Duration maximumAdvance;

    @JsonProperty("sendConfirmationsToOwner")
    protected Boolean sendConfirmationsToOwner;

    @JsonProperty("allowStaffSelection")
    protected Boolean allowStaffSelection;

    protected BookingSchedulingPolicy() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.bookingSchedulingPolicy";
    }

    /**
     * <i>“Duration of each time slot.”</i>
     * 
     * @return property timeSlotInterval
     */
    @Property(name="timeSlotInterval")
    @JsonIgnore
    public Optional<Duration> getTimeSlotInterval() {
        return Optional.ofNullable(timeSlotInterval);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code timeSlotInterval}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Duration of each time slot.”</i>
     * 
     * @param timeSlotInterval
     *            new value of {@code timeSlotInterval} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code timeSlotInterval} field changed
     */
    public BookingSchedulingPolicy withTimeSlotInterval(Duration timeSlotInterval) {
        BookingSchedulingPolicy _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingSchedulingPolicy");
        _x.timeSlotInterval = timeSlotInterval;
        return _x;
    }

    /**
     * <i>“Minimum lead time for bookings and cancellations.”</i>
     * 
     * @return property minimumLeadTime
     */
    @Property(name="minimumLeadTime")
    @JsonIgnore
    public Optional<Duration> getMinimumLeadTime() {
        return Optional.ofNullable(minimumLeadTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code minimumLeadTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Minimum lead time for bookings and cancellations.”</i>
     * 
     * @param minimumLeadTime
     *            new value of {@code minimumLeadTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minimumLeadTime} field changed
     */
    public BookingSchedulingPolicy withMinimumLeadTime(Duration minimumLeadTime) {
        BookingSchedulingPolicy _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingSchedulingPolicy");
        _x.minimumLeadTime = minimumLeadTime;
        return _x;
    }

    /**
     * <i>“Maximum number of days in advance that a booking can be made.”</i>
     * 
     * @return property maximumAdvance
     */
    @Property(name="maximumAdvance")
    @JsonIgnore
    public Optional<Duration> getMaximumAdvance() {
        return Optional.ofNullable(maximumAdvance);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code maximumAdvance}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Maximum number of days in advance that a booking can be made.”</i>
     * 
     * @param maximumAdvance
     *            new value of {@code maximumAdvance} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code maximumAdvance} field changed
     */
    public BookingSchedulingPolicy withMaximumAdvance(Duration maximumAdvance) {
        BookingSchedulingPolicy _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingSchedulingPolicy");
        _x.maximumAdvance = maximumAdvance;
        return _x;
    }

    /**
     * <i>“Notify the business via email when a booking is created or changed.”</i>
     * 
     * @return property sendConfirmationsToOwner
     */
    @Property(name="sendConfirmationsToOwner")
    @JsonIgnore
    public Optional<Boolean> getSendConfirmationsToOwner() {
        return Optional.ofNullable(sendConfirmationsToOwner);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * sendConfirmationsToOwner} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Notify the business via email when a booking is created or changed.”</i>
     * 
     * @param sendConfirmationsToOwner
     *            new value of {@code sendConfirmationsToOwner} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code sendConfirmationsToOwner} field changed
     */
    public BookingSchedulingPolicy withSendConfirmationsToOwner(Boolean sendConfirmationsToOwner) {
        BookingSchedulingPolicy _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingSchedulingPolicy");
        _x.sendConfirmationsToOwner = sendConfirmationsToOwner;
        return _x;
    }

    /**
     * <i>“Allow customers to choose a specific person for the booking.”</i>
     * 
     * @return property allowStaffSelection
     */
    @Property(name="allowStaffSelection")
    @JsonIgnore
    public Optional<Boolean> getAllowStaffSelection() {
        return Optional.ofNullable(allowStaffSelection);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * allowStaffSelection} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Allow customers to choose a specific person for the booking.”</i>
     * 
     * @param allowStaffSelection
     *            new value of {@code allowStaffSelection} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code allowStaffSelection} field changed
     */
    public BookingSchedulingPolicy withAllowStaffSelection(Boolean allowStaffSelection) {
        BookingSchedulingPolicy _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingSchedulingPolicy");
        _x.allowStaffSelection = allowStaffSelection;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Duration timeSlotInterval;
        private Duration minimumLeadTime;
        private Duration maximumAdvance;
        private Boolean sendConfirmationsToOwner;
        private Boolean allowStaffSelection;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Duration of each time slot.”</i>
         * 
         * @param timeSlotInterval
         *            value of {@code timeSlotInterval} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder timeSlotInterval(Duration timeSlotInterval) {
            this.timeSlotInterval = timeSlotInterval;
            this.changedFields = changedFields.add("timeSlotInterval");
            return this;
        }

        /**
         * <i>“Minimum lead time for bookings and cancellations.”</i>
         * 
         * @param minimumLeadTime
         *            value of {@code minimumLeadTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minimumLeadTime(Duration minimumLeadTime) {
            this.minimumLeadTime = minimumLeadTime;
            this.changedFields = changedFields.add("minimumLeadTime");
            return this;
        }

        /**
         * <i>“Maximum number of days in advance that a booking can be made.”</i>
         * 
         * @param maximumAdvance
         *            value of {@code maximumAdvance} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder maximumAdvance(Duration maximumAdvance) {
            this.maximumAdvance = maximumAdvance;
            this.changedFields = changedFields.add("maximumAdvance");
            return this;
        }

        /**
         * <i>“Notify the business via email when a booking is created or changed.”</i>
         * 
         * @param sendConfirmationsToOwner
         *            value of {@code sendConfirmationsToOwner} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder sendConfirmationsToOwner(Boolean sendConfirmationsToOwner) {
            this.sendConfirmationsToOwner = sendConfirmationsToOwner;
            this.changedFields = changedFields.add("sendConfirmationsToOwner");
            return this;
        }

        /**
         * <i>“Allow customers to choose a specific person for the booking.”</i>
         * 
         * @param allowStaffSelection
         *            value of {@code allowStaffSelection} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowStaffSelection(Boolean allowStaffSelection) {
            this.allowStaffSelection = allowStaffSelection;
            this.changedFields = changedFields.add("allowStaffSelection");
            return this;
        }

        public BookingSchedulingPolicy build() {
            BookingSchedulingPolicy _x = new BookingSchedulingPolicy();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.bookingSchedulingPolicy";
            _x.timeSlotInterval = timeSlotInterval;
            _x.minimumLeadTime = minimumLeadTime;
            _x.maximumAdvance = maximumAdvance;
            _x.sendConfirmationsToOwner = sendConfirmationsToOwner;
            _x.allowStaffSelection = allowStaffSelection;
            return _x;
        }
    }

    private BookingSchedulingPolicy _copy() {
        BookingSchedulingPolicy _x = new BookingSchedulingPolicy();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.timeSlotInterval = timeSlotInterval;
        _x.minimumLeadTime = minimumLeadTime;
        _x.maximumAdvance = maximumAdvance;
        _x.sendConfirmationsToOwner = sendConfirmationsToOwner;
        _x.allowStaffSelection = allowStaffSelection;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("BookingSchedulingPolicy[");
        b.append("timeSlotInterval=");
        b.append(this.timeSlotInterval);
        b.append(", ");
        b.append("minimumLeadTime=");
        b.append(this.minimumLeadTime);
        b.append(", ");
        b.append("maximumAdvance=");
        b.append(this.maximumAdvance);
        b.append(", ");
        b.append("sendConfirmationsToOwner=");
        b.append(this.sendConfirmationsToOwner);
        b.append(", ");
        b.append("allowStaffSelection=");
        b.append(this.allowStaffSelection);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
