package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.BitLockerEncryptionMethod;


/**
 * <i>“BitLocker Fixed Drive Policies.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "encryptionMethod", 
    "requireEncryptionForWriteAccess", 
    "recoveryOptions"})
@JsonInclude(Include.NON_NULL)
public class BitLockerFixedDrivePolicy implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("encryptionMethod")
    protected BitLockerEncryptionMethod encryptionMethod;

    @JsonProperty("requireEncryptionForWriteAccess")
    protected Boolean requireEncryptionForWriteAccess;

    @JsonProperty("recoveryOptions")
    protected BitLockerRecoveryOptions recoveryOptions;

    protected BitLockerFixedDrivePolicy() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.bitLockerFixedDrivePolicy";
    }

    /**
     * <i>“Select the encryption method for fixed drives.”</i>
     * 
     * @return property encryptionMethod
     */
    @Property(name="encryptionMethod")
    @JsonIgnore
    public Optional<BitLockerEncryptionMethod> getEncryptionMethod() {
        return Optional.ofNullable(encryptionMethod);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code encryptionMethod}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Select the encryption method for fixed drives.”</i>
     * 
     * @param encryptionMethod
     *            new value of {@code encryptionMethod} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code encryptionMethod} field changed
     */
    public BitLockerFixedDrivePolicy withEncryptionMethod(BitLockerEncryptionMethod encryptionMethod) {
        BitLockerFixedDrivePolicy _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bitLockerFixedDrivePolicy");
        _x.encryptionMethod = encryptionMethod;
        return _x;
    }

    /**
     * <i>“This policy setting determines whether BitLocker protection is required for
     * fixed data drives to be writable on a computer.”</i>
     * 
     * @return property requireEncryptionForWriteAccess
     */
    @Property(name="requireEncryptionForWriteAccess")
    @JsonIgnore
    public Optional<Boolean> getRequireEncryptionForWriteAccess() {
        return Optional.ofNullable(requireEncryptionForWriteAccess);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * requireEncryptionForWriteAccess} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“This policy setting determines whether BitLocker protection is required for
     * fixed data drives to be writable on a computer.”</i>
     * 
     * @param requireEncryptionForWriteAccess
     *            new value of {@code requireEncryptionForWriteAccess} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code requireEncryptionForWriteAccess} field changed
     */
    public BitLockerFixedDrivePolicy withRequireEncryptionForWriteAccess(Boolean requireEncryptionForWriteAccess) {
        BitLockerFixedDrivePolicy _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bitLockerFixedDrivePolicy");
        _x.requireEncryptionForWriteAccess = requireEncryptionForWriteAccess;
        return _x;
    }

    /**
     * <i>“This policy setting allows you to control how BitLocker-protected fixed data
     * drives are recovered in the absence of the required credentials. This policy
     * setting is applied when you turn on BitLocker.”</i>
     * 
     * @return property recoveryOptions
     */
    @Property(name="recoveryOptions")
    @JsonIgnore
    public Optional<BitLockerRecoveryOptions> getRecoveryOptions() {
        return Optional.ofNullable(recoveryOptions);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code recoveryOptions}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“This policy setting allows you to control how BitLocker-protected fixed data
     * drives are recovered in the absence of the required credentials. This policy
     * setting is applied when you turn on BitLocker.”</i>
     * 
     * @param recoveryOptions
     *            new value of {@code recoveryOptions} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code recoveryOptions} field changed
     */
    public BitLockerFixedDrivePolicy withRecoveryOptions(BitLockerRecoveryOptions recoveryOptions) {
        BitLockerFixedDrivePolicy _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bitLockerFixedDrivePolicy");
        _x.recoveryOptions = recoveryOptions;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private BitLockerEncryptionMethod encryptionMethod;
        private Boolean requireEncryptionForWriteAccess;
        private BitLockerRecoveryOptions recoveryOptions;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Select the encryption method for fixed drives.”</i>
         * 
         * @param encryptionMethod
         *            value of {@code encryptionMethod} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder encryptionMethod(BitLockerEncryptionMethod encryptionMethod) {
            this.encryptionMethod = encryptionMethod;
            this.changedFields = changedFields.add("encryptionMethod");
            return this;
        }

        /**
         * <i>“This policy setting determines whether BitLocker protection is required for
         * fixed data drives to be writable on a computer.”</i>
         * 
         * @param requireEncryptionForWriteAccess
         *            value of {@code requireEncryptionForWriteAccess} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder requireEncryptionForWriteAccess(Boolean requireEncryptionForWriteAccess) {
            this.requireEncryptionForWriteAccess = requireEncryptionForWriteAccess;
            this.changedFields = changedFields.add("requireEncryptionForWriteAccess");
            return this;
        }

        /**
         * <i>“This policy setting allows you to control how BitLocker-protected fixed data
         * drives are recovered in the absence of the required credentials. This policy
         * setting is applied when you turn on BitLocker.”</i>
         * 
         * @param recoveryOptions
         *            value of {@code recoveryOptions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder recoveryOptions(BitLockerRecoveryOptions recoveryOptions) {
            this.recoveryOptions = recoveryOptions;
            this.changedFields = changedFields.add("recoveryOptions");
            return this;
        }

        public BitLockerFixedDrivePolicy build() {
            BitLockerFixedDrivePolicy _x = new BitLockerFixedDrivePolicy();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.bitLockerFixedDrivePolicy";
            _x.encryptionMethod = encryptionMethod;
            _x.requireEncryptionForWriteAccess = requireEncryptionForWriteAccess;
            _x.recoveryOptions = recoveryOptions;
            return _x;
        }
    }

    private BitLockerFixedDrivePolicy _copy() {
        BitLockerFixedDrivePolicy _x = new BitLockerFixedDrivePolicy();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.encryptionMethod = encryptionMethod;
        _x.requireEncryptionForWriteAccess = requireEncryptionForWriteAccess;
        _x.recoveryOptions = recoveryOptions;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("BitLockerFixedDrivePolicy[");
        b.append("encryptionMethod=");
        b.append(this.encryptionMethod);
        b.append(", ");
        b.append("requireEncryptionForWriteAccess=");
        b.append(this.requireEncryptionForWriteAccess);
        b.append(", ");
        b.append("recoveryOptions=");
        b.append(this.recoveryOptions);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
