package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.BinaryManagementConditionExpressionOperatorType;


/**
 * <i>“A management condition expression that is evaluated using a binary operation.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "operator", 
    "firstOperand", 
    "secondOperand"})
@JsonInclude(Include.NON_NULL)
public class BinaryManagementConditionExpression extends ManagementConditionExpressionModel implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("operator")
    protected BinaryManagementConditionExpressionOperatorType operator;

    @JsonProperty("firstOperand")
    protected ManagementConditionExpressionModel firstOperand;

    @JsonProperty("secondOperand")
    protected ManagementConditionExpressionModel secondOperand;

    protected BinaryManagementConditionExpression() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.binaryManagementConditionExpression";
    }

    /**
     * <i>“The operator used in the evaluation of the binary operation.”</i>
     * 
     * @return property operator
     */
    @Property(name="operator")
    @JsonIgnore
    public Optional<BinaryManagementConditionExpressionOperatorType> getOperator() {
        return Optional.ofNullable(operator);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code operator} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The operator used in the evaluation of the binary operation.”</i>
     * 
     * @param operator
     *            new value of {@code operator} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code operator} field changed
     */
    public BinaryManagementConditionExpression withOperator(BinaryManagementConditionExpressionOperatorType operator) {
        BinaryManagementConditionExpression _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.binaryManagementConditionExpression");
        _x.operator = operator;
        return _x;
    }

    /**
     * <i>“The first operand of the binary operation.”</i>
     * 
     * @return property firstOperand
     */
    @Property(name="firstOperand")
    @JsonIgnore
    public Optional<ManagementConditionExpressionModel> getFirstOperand() {
        return Optional.ofNullable(firstOperand);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code firstOperand}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The first operand of the binary operation.”</i>
     * 
     * @param firstOperand
     *            new value of {@code firstOperand} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code firstOperand} field changed
     */
    public BinaryManagementConditionExpression withFirstOperand(ManagementConditionExpressionModel firstOperand) {
        BinaryManagementConditionExpression _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.binaryManagementConditionExpression");
        _x.firstOperand = firstOperand;
        return _x;
    }

    /**
     * <i>“The second operand of the binary operation.”</i>
     * 
     * @return property secondOperand
     */
    @Property(name="secondOperand")
    @JsonIgnore
    public Optional<ManagementConditionExpressionModel> getSecondOperand() {
        return Optional.ofNullable(secondOperand);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code secondOperand}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The second operand of the binary operation.”</i>
     * 
     * @param secondOperand
     *            new value of {@code secondOperand} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code secondOperand} field changed
     */
    public BinaryManagementConditionExpression withSecondOperand(ManagementConditionExpressionModel secondOperand) {
        BinaryManagementConditionExpression _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.binaryManagementConditionExpression");
        _x.secondOperand = secondOperand;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderBinaryManagementConditionExpression() {
        return new Builder();
    }

    public static final class Builder {
        private BinaryManagementConditionExpressionOperatorType operator;
        private ManagementConditionExpressionModel firstOperand;
        private ManagementConditionExpressionModel secondOperand;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“The operator used in the evaluation of the binary operation.”</i>
         * 
         * @param operator
         *            value of {@code operator} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder operator(BinaryManagementConditionExpressionOperatorType operator) {
            this.operator = operator;
            this.changedFields = changedFields.add("operator");
            return this;
        }

        /**
         * <i>“The first operand of the binary operation.”</i>
         * 
         * @param firstOperand
         *            value of {@code firstOperand} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder firstOperand(ManagementConditionExpressionModel firstOperand) {
            this.firstOperand = firstOperand;
            this.changedFields = changedFields.add("firstOperand");
            return this;
        }

        /**
         * <i>“The second operand of the binary operation.”</i>
         * 
         * @param secondOperand
         *            value of {@code secondOperand} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder secondOperand(ManagementConditionExpressionModel secondOperand) {
            this.secondOperand = secondOperand;
            this.changedFields = changedFields.add("secondOperand");
            return this;
        }

        public BinaryManagementConditionExpression build() {
            BinaryManagementConditionExpression _x = new BinaryManagementConditionExpression();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.binaryManagementConditionExpression";
            _x.operator = operator;
            _x.firstOperand = firstOperand;
            _x.secondOperand = secondOperand;
            return _x;
        }
    }

    private BinaryManagementConditionExpression _copy() {
        BinaryManagementConditionExpression _x = new BinaryManagementConditionExpression();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.operator = operator;
        _x.firstOperand = firstOperand;
        _x.secondOperand = secondOperand;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("BinaryManagementConditionExpression[");
        b.append("operator=");
        b.append(this.operator);
        b.append(", ");
        b.append("firstOperand=");
        b.append(this.firstOperand);
        b.append(", ");
        b.append("secondOperand=");
        b.append(this.secondOperand);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
