package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "tenantId", 
    "displayName"})
@JsonInclude(Include.NON_NULL)
public class AzureActiveDirectoryTenant extends IdentitySource implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("tenantId")
    protected String tenantId;

    @JsonProperty("displayName")
    protected String displayName;

    protected AzureActiveDirectoryTenant() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.azureActiveDirectoryTenant";
    }

    @Property(name="tenantId")
    @JsonIgnore
    public Optional<String> getTenantId() {
        return Optional.ofNullable(tenantId);
    }

    public AzureActiveDirectoryTenant withTenantId(String tenantId) {
        AzureActiveDirectoryTenant _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.azureActiveDirectoryTenant");
        _x.tenantId = tenantId;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public AzureActiveDirectoryTenant withDisplayName(String displayName) {
        AzureActiveDirectoryTenant _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.azureActiveDirectoryTenant");
        _x.displayName = displayName;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAzureActiveDirectoryTenant() {
        return new Builder();
    }

    public static final class Builder {
        private String tenantId;
        private String displayName;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            this.changedFields = changedFields.add("tenantId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public AzureActiveDirectoryTenant build() {
            AzureActiveDirectoryTenant _x = new AzureActiveDirectoryTenant();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.azureActiveDirectoryTenant";
            _x.tenantId = tenantId;
            _x.displayName = displayName;
            return _x;
        }
    }

    private AzureActiveDirectoryTenant _copy() {
        AzureActiveDirectoryTenant _x = new AzureActiveDirectoryTenant();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.tenantId = tenantId;
        _x.displayName = displayName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AzureActiveDirectoryTenant[");
        b.append("tenantId=");
        b.append(this.tenantId);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
