package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "notReviewedResult"})
@JsonInclude(Include.NON_NULL)
public class AutoReviewSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("notReviewedResult")
    protected String notReviewedResult;

    protected AutoReviewSettings() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.autoReviewSettings";
    }

    @Property(name="notReviewedResult")
    @JsonIgnore
    public Optional<String> getNotReviewedResult() {
        return Optional.ofNullable(notReviewedResult);
    }

    public AutoReviewSettings withNotReviewedResult(String notReviewedResult) {
        AutoReviewSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.autoReviewSettings");
        _x.notReviewedResult = notReviewedResult;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String notReviewedResult;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder notReviewedResult(String notReviewedResult) {
            this.notReviewedResult = notReviewedResult;
            this.changedFields = changedFields.add("notReviewedResult");
            return this;
        }

        public AutoReviewSettings build() {
            AutoReviewSettings _x = new AutoReviewSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.autoReviewSettings";
            _x.notReviewedResult = notReviewedResult;
            return _x;
        }
    }

    private AutoReviewSettings _copy() {
        AutoReviewSettings _x = new AutoReviewSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.notReviewedResult = notReviewedResult;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AutoReviewSettings[");
        b.append("notReviewedResult=");
        b.append(this.notReviewedResult);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
