package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "sensitiveTypeIds", 
    "message"})
@JsonInclude(Include.NON_NULL)
public class AutoLabeling implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("sensitiveTypeIds")
    protected List<String> sensitiveTypeIds;

    @JsonProperty("sensitiveTypeIds@nextLink")
    protected String sensitiveTypeIdsNextLink;

    @JsonProperty("message")
    protected String message;

    protected AutoLabeling() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.autoLabeling";
    }

    @Property(name="sensitiveTypeIds")
    @JsonIgnore
    public CollectionPage<String> getSensitiveTypeIds() {
        return new CollectionPage<String>(contextPath, String.class, sensitiveTypeIds, Optional.ofNullable(sensitiveTypeIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="sensitiveTypeIds")
    @JsonIgnore
    public CollectionPage<String> getSensitiveTypeIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, sensitiveTypeIds, Optional.ofNullable(sensitiveTypeIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="message")
    @JsonIgnore
    public Optional<String> getMessage() {
        return Optional.ofNullable(message);
    }

    public AutoLabeling withMessage(String message) {
        AutoLabeling _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.autoLabeling");
        _x.message = message;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> sensitiveTypeIds;
        private String sensitiveTypeIdsNextLink;
        private String message;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder sensitiveTypeIds(List<String> sensitiveTypeIds) {
            this.sensitiveTypeIds = sensitiveTypeIds;
            this.changedFields = changedFields.add("sensitiveTypeIds");
            return this;
        }

        public Builder sensitiveTypeIds(String... sensitiveTypeIds) {
            return sensitiveTypeIds(Arrays.asList(sensitiveTypeIds));
        }

        public Builder sensitiveTypeIdsNextLink(String sensitiveTypeIdsNextLink) {
            this.sensitiveTypeIdsNextLink = sensitiveTypeIdsNextLink;
            this.changedFields = changedFields.add("sensitiveTypeIds");
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            this.changedFields = changedFields.add("message");
            return this;
        }

        public AutoLabeling build() {
            AutoLabeling _x = new AutoLabeling();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.autoLabeling";
            _x.sensitiveTypeIds = sensitiveTypeIds;
            _x.sensitiveTypeIdsNextLink = sensitiveTypeIdsNextLink;
            _x.message = message;
            return _x;
        }
    }

    private AutoLabeling _copy() {
        AutoLabeling _x = new AutoLabeling();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.sensitiveTypeIds = sensitiveTypeIds;
        _x.message = message;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AutoLabeling[");
        b.append("sensitiveTypeIds=");
        b.append(this.sensitiveTypeIds);
        b.append(", ");
        b.append("message=");
        b.append(this.message);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
