package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.RequirementProvider;

@JsonPropertyOrder({
    "@odata.type", 
    "requirementProvider", 
    "detail"})
@JsonInclude(Include.NON_NULL)
public class AuthenticationRequirementPolicy implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("requirementProvider")
    protected RequirementProvider requirementProvider;

    @JsonProperty("detail")
    protected String detail;

    protected AuthenticationRequirementPolicy() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.authenticationRequirementPolicy";
    }

    @Property(name="requirementProvider")
    @JsonIgnore
    public Optional<RequirementProvider> getRequirementProvider() {
        return Optional.ofNullable(requirementProvider);
    }

    public AuthenticationRequirementPolicy withRequirementProvider(RequirementProvider requirementProvider) {
        AuthenticationRequirementPolicy _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.authenticationRequirementPolicy");
        _x.requirementProvider = requirementProvider;
        return _x;
    }

    @Property(name="detail")
    @JsonIgnore
    public Optional<String> getDetail() {
        return Optional.ofNullable(detail);
    }

    public AuthenticationRequirementPolicy withDetail(String detail) {
        AuthenticationRequirementPolicy _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.authenticationRequirementPolicy");
        _x.detail = detail;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private RequirementProvider requirementProvider;
        private String detail;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder requirementProvider(RequirementProvider requirementProvider) {
            this.requirementProvider = requirementProvider;
            this.changedFields = changedFields.add("requirementProvider");
            return this;
        }

        public Builder detail(String detail) {
            this.detail = detail;
            this.changedFields = changedFields.add("detail");
            return this;
        }

        public AuthenticationRequirementPolicy build() {
            AuthenticationRequirementPolicy _x = new AuthenticationRequirementPolicy();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.authenticationRequirementPolicy";
            _x.requirementProvider = requirementProvider;
            _x.detail = detail;
            return _x;
        }
    }

    private AuthenticationRequirementPolicy _copy() {
        AuthenticationRequirementPolicy _x = new AuthenticationRequirementPolicy();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.requirementProvider = requirementProvider;
        _x.detail = detail;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AuthenticationRequirementPolicy[");
        b.append("requirementProvider=");
        b.append(this.requirementProvider);
        b.append(", ");
        b.append("detail=");
        b.append(this.detail);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
