package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "authenticationStepDateTime", 
    "authenticationMethod", 
    "authenticationMethodDetail", 
    "succeeded", 
    "authenticationStepResultDetail", 
    "authenticationStepRequirement"})
@JsonInclude(Include.NON_NULL)
public class AuthenticationDetail implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("authenticationStepDateTime")
    protected OffsetDateTime authenticationStepDateTime;

    @JsonProperty("authenticationMethod")
    protected String authenticationMethod;

    @JsonProperty("authenticationMethodDetail")
    protected String authenticationMethodDetail;

    @JsonProperty("succeeded")
    protected Boolean succeeded;

    @JsonProperty("authenticationStepResultDetail")
    protected String authenticationStepResultDetail;

    @JsonProperty("authenticationStepRequirement")
    protected String authenticationStepRequirement;

    protected AuthenticationDetail() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.authenticationDetail";
    }

    @Property(name="authenticationStepDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getAuthenticationStepDateTime() {
        return Optional.ofNullable(authenticationStepDateTime);
    }

    public AuthenticationDetail withAuthenticationStepDateTime(OffsetDateTime authenticationStepDateTime) {
        AuthenticationDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.authenticationDetail");
        _x.authenticationStepDateTime = authenticationStepDateTime;
        return _x;
    }

    @Property(name="authenticationMethod")
    @JsonIgnore
    public Optional<String> getAuthenticationMethod() {
        return Optional.ofNullable(authenticationMethod);
    }

    public AuthenticationDetail withAuthenticationMethod(String authenticationMethod) {
        AuthenticationDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.authenticationDetail");
        _x.authenticationMethod = authenticationMethod;
        return _x;
    }

    @Property(name="authenticationMethodDetail")
    @JsonIgnore
    public Optional<String> getAuthenticationMethodDetail() {
        return Optional.ofNullable(authenticationMethodDetail);
    }

    public AuthenticationDetail withAuthenticationMethodDetail(String authenticationMethodDetail) {
        AuthenticationDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.authenticationDetail");
        _x.authenticationMethodDetail = authenticationMethodDetail;
        return _x;
    }

    @Property(name="succeeded")
    @JsonIgnore
    public Optional<Boolean> getSucceeded() {
        return Optional.ofNullable(succeeded);
    }

    public AuthenticationDetail withSucceeded(Boolean succeeded) {
        AuthenticationDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.authenticationDetail");
        _x.succeeded = succeeded;
        return _x;
    }

    @Property(name="authenticationStepResultDetail")
    @JsonIgnore
    public Optional<String> getAuthenticationStepResultDetail() {
        return Optional.ofNullable(authenticationStepResultDetail);
    }

    public AuthenticationDetail withAuthenticationStepResultDetail(String authenticationStepResultDetail) {
        AuthenticationDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.authenticationDetail");
        _x.authenticationStepResultDetail = authenticationStepResultDetail;
        return _x;
    }

    @Property(name="authenticationStepRequirement")
    @JsonIgnore
    public Optional<String> getAuthenticationStepRequirement() {
        return Optional.ofNullable(authenticationStepRequirement);
    }

    public AuthenticationDetail withAuthenticationStepRequirement(String authenticationStepRequirement) {
        AuthenticationDetail _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.authenticationDetail");
        _x.authenticationStepRequirement = authenticationStepRequirement;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime authenticationStepDateTime;
        private String authenticationMethod;
        private String authenticationMethodDetail;
        private Boolean succeeded;
        private String authenticationStepResultDetail;
        private String authenticationStepRequirement;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder authenticationStepDateTime(OffsetDateTime authenticationStepDateTime) {
            this.authenticationStepDateTime = authenticationStepDateTime;
            this.changedFields = changedFields.add("authenticationStepDateTime");
            return this;
        }

        public Builder authenticationMethod(String authenticationMethod) {
            this.authenticationMethod = authenticationMethod;
            this.changedFields = changedFields.add("authenticationMethod");
            return this;
        }

        public Builder authenticationMethodDetail(String authenticationMethodDetail) {
            this.authenticationMethodDetail = authenticationMethodDetail;
            this.changedFields = changedFields.add("authenticationMethodDetail");
            return this;
        }

        public Builder succeeded(Boolean succeeded) {
            this.succeeded = succeeded;
            this.changedFields = changedFields.add("succeeded");
            return this;
        }

        public Builder authenticationStepResultDetail(String authenticationStepResultDetail) {
            this.authenticationStepResultDetail = authenticationStepResultDetail;
            this.changedFields = changedFields.add("authenticationStepResultDetail");
            return this;
        }

        public Builder authenticationStepRequirement(String authenticationStepRequirement) {
            this.authenticationStepRequirement = authenticationStepRequirement;
            this.changedFields = changedFields.add("authenticationStepRequirement");
            return this;
        }

        public AuthenticationDetail build() {
            AuthenticationDetail _x = new AuthenticationDetail();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.authenticationDetail";
            _x.authenticationStepDateTime = authenticationStepDateTime;
            _x.authenticationMethod = authenticationMethod;
            _x.authenticationMethodDetail = authenticationMethodDetail;
            _x.succeeded = succeeded;
            _x.authenticationStepResultDetail = authenticationStepResultDetail;
            _x.authenticationStepRequirement = authenticationStepRequirement;
            return _x;
        }
    }

    private AuthenticationDetail _copy() {
        AuthenticationDetail _x = new AuthenticationDetail();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.authenticationStepDateTime = authenticationStepDateTime;
        _x.authenticationMethod = authenticationMethod;
        _x.authenticationMethodDetail = authenticationMethodDetail;
        _x.succeeded = succeeded;
        _x.authenticationStepResultDetail = authenticationStepResultDetail;
        _x.authenticationStepRequirement = authenticationStepRequirement;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AuthenticationDetail[");
        b.append("authenticationStepDateTime=");
        b.append(this.authenticationStepDateTime);
        b.append(", ");
        b.append("authenticationMethod=");
        b.append(this.authenticationMethod);
        b.append(", ");
        b.append("authenticationMethodDetail=");
        b.append(this.authenticationMethodDetail);
        b.append(", ");
        b.append("succeeded=");
        b.append(this.succeeded);
        b.append(", ");
        b.append("authenticationStepResultDetail=");
        b.append(this.authenticationStepResultDetail);
        b.append(", ");
        b.append("authenticationStepRequirement=");
        b.append(this.authenticationStepRequirement);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
