package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "user", 
    "app"})
@JsonInclude(Include.NON_NULL)
public class AuditActivityInitiator implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("user")
    protected UserIdentity user;

    @JsonProperty("app")
    protected AppIdentity app;

    protected AuditActivityInitiator() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.auditActivityInitiator";
    }

    @Property(name="user")
    @JsonIgnore
    public Optional<UserIdentity> getUser() {
        return Optional.ofNullable(user);
    }

    public AuditActivityInitiator withUser(UserIdentity user) {
        AuditActivityInitiator _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.auditActivityInitiator");
        _x.user = user;
        return _x;
    }

    @Property(name="app")
    @JsonIgnore
    public Optional<AppIdentity> getApp() {
        return Optional.ofNullable(app);
    }

    public AuditActivityInitiator withApp(AppIdentity app) {
        AuditActivityInitiator _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.auditActivityInitiator");
        _x.app = app;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private UserIdentity user;
        private AppIdentity app;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder user(UserIdentity user) {
            this.user = user;
            this.changedFields = changedFields.add("user");
            return this;
        }

        public Builder app(AppIdentity app) {
            this.app = app;
            this.changedFields = changedFields.add("app");
            return this;
        }

        public AuditActivityInitiator build() {
            AuditActivityInitiator _x = new AuditActivityInitiator();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.auditActivityInitiator";
            _x.user = user;
            _x.app = app;
            return _x;
        }
    }

    private AuditActivityInitiator _copy() {
        AuditActivityInitiator _x = new AuditActivityInitiator();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.user = user;
        _x.app = app;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AuditActivityInitiator[");
        b.append("user=");
        b.append(this.user);
        b.append(", ");
        b.append("app=");
        b.append(this.app);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
