package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "conferenceId", 
    "tollNumber", 
    "tollFreeNumber", 
    "dialinUrl"})
@JsonInclude(Include.NON_NULL)
public class AudioConferencing implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("conferenceId")
    protected String conferenceId;

    @JsonProperty("tollNumber")
    protected String tollNumber;

    @JsonProperty("tollFreeNumber")
    protected String tollFreeNumber;

    @JsonProperty("dialinUrl")
    protected String dialinUrl;

    protected AudioConferencing() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.audioConferencing";
    }

    @Property(name="conferenceId")
    @JsonIgnore
    public Optional<String> getConferenceId() {
        return Optional.ofNullable(conferenceId);
    }

    public AudioConferencing withConferenceId(String conferenceId) {
        AudioConferencing _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.audioConferencing");
        _x.conferenceId = conferenceId;
        return _x;
    }

    @Property(name="tollNumber")
    @JsonIgnore
    public Optional<String> getTollNumber() {
        return Optional.ofNullable(tollNumber);
    }

    public AudioConferencing withTollNumber(String tollNumber) {
        AudioConferencing _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.audioConferencing");
        _x.tollNumber = tollNumber;
        return _x;
    }

    @Property(name="tollFreeNumber")
    @JsonIgnore
    public Optional<String> getTollFreeNumber() {
        return Optional.ofNullable(tollFreeNumber);
    }

    public AudioConferencing withTollFreeNumber(String tollFreeNumber) {
        AudioConferencing _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.audioConferencing");
        _x.tollFreeNumber = tollFreeNumber;
        return _x;
    }

    @Property(name="dialinUrl")
    @JsonIgnore
    public Optional<String> getDialinUrl() {
        return Optional.ofNullable(dialinUrl);
    }

    public AudioConferencing withDialinUrl(String dialinUrl) {
        AudioConferencing _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.audioConferencing");
        _x.dialinUrl = dialinUrl;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String conferenceId;
        private String tollNumber;
        private String tollFreeNumber;
        private String dialinUrl;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder conferenceId(String conferenceId) {
            this.conferenceId = conferenceId;
            this.changedFields = changedFields.add("conferenceId");
            return this;
        }

        public Builder tollNumber(String tollNumber) {
            this.tollNumber = tollNumber;
            this.changedFields = changedFields.add("tollNumber");
            return this;
        }

        public Builder tollFreeNumber(String tollFreeNumber) {
            this.tollFreeNumber = tollFreeNumber;
            this.changedFields = changedFields.add("tollFreeNumber");
            return this;
        }

        public Builder dialinUrl(String dialinUrl) {
            this.dialinUrl = dialinUrl;
            this.changedFields = changedFields.add("dialinUrl");
            return this;
        }

        public AudioConferencing build() {
            AudioConferencing _x = new AudioConferencing();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.audioConferencing";
            _x.conferenceId = conferenceId;
            _x.tollNumber = tollNumber;
            _x.tollFreeNumber = tollFreeNumber;
            _x.dialinUrl = dialinUrl;
            return _x;
        }
    }

    private AudioConferencing _copy() {
        AudioConferencing _x = new AudioConferencing();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.conferenceId = conferenceId;
        _x.tollNumber = tollNumber;
        _x.tollFreeNumber = tollFreeNumber;
        _x.dialinUrl = dialinUrl;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AudioConferencing[");
        b.append("conferenceId=");
        b.append(this.conferenceId);
        b.append(", ");
        b.append("tollNumber=");
        b.append(this.tollNumber);
        b.append(", ");
        b.append("tollFreeNumber=");
        b.append(this.tollFreeNumber);
        b.append(", ");
        b.append("dialinUrl=");
        b.append(this.dialinUrl);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
