package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.AttributeFlowBehavior;
import odata.msgraph.client.beta.enums.AttributeFlowType;

@JsonPropertyOrder({
    "@odata.type", 
    "defaultValue", 
    "exportMissingReferences", 
    "flowBehavior", 
    "flowType", 
    "matchingPriority", 
    "source", 
    "targetAttributeName"})
@JsonInclude(Include.NON_NULL)
public class AttributeMapping implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("defaultValue")
    protected String defaultValue;

    @JsonProperty("exportMissingReferences")
    protected Boolean exportMissingReferences;

    @JsonProperty("flowBehavior")
    protected AttributeFlowBehavior flowBehavior;

    @JsonProperty("flowType")
    protected AttributeFlowType flowType;

    @JsonProperty("matchingPriority")
    protected Integer matchingPriority;

    @JsonProperty("source")
    protected AttributeMappingSource source;

    @JsonProperty("targetAttributeName")
    protected String targetAttributeName;

    protected AttributeMapping() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.attributeMapping";
    }

    @Property(name="defaultValue")
    @JsonIgnore
    public Optional<String> getDefaultValue() {
        return Optional.ofNullable(defaultValue);
    }

    public AttributeMapping withDefaultValue(String defaultValue) {
        AttributeMapping _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attributeMapping");
        _x.defaultValue = defaultValue;
        return _x;
    }

    @Property(name="exportMissingReferences")
    @JsonIgnore
    public Optional<Boolean> getExportMissingReferences() {
        return Optional.ofNullable(exportMissingReferences);
    }

    public AttributeMapping withExportMissingReferences(Boolean exportMissingReferences) {
        AttributeMapping _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attributeMapping");
        _x.exportMissingReferences = exportMissingReferences;
        return _x;
    }

    @Property(name="flowBehavior")
    @JsonIgnore
    public Optional<AttributeFlowBehavior> getFlowBehavior() {
        return Optional.ofNullable(flowBehavior);
    }

    public AttributeMapping withFlowBehavior(AttributeFlowBehavior flowBehavior) {
        AttributeMapping _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attributeMapping");
        _x.flowBehavior = flowBehavior;
        return _x;
    }

    @Property(name="flowType")
    @JsonIgnore
    public Optional<AttributeFlowType> getFlowType() {
        return Optional.ofNullable(flowType);
    }

    public AttributeMapping withFlowType(AttributeFlowType flowType) {
        AttributeMapping _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attributeMapping");
        _x.flowType = flowType;
        return _x;
    }

    @Property(name="matchingPriority")
    @JsonIgnore
    public Optional<Integer> getMatchingPriority() {
        return Optional.ofNullable(matchingPriority);
    }

    public AttributeMapping withMatchingPriority(Integer matchingPriority) {
        AttributeMapping _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attributeMapping");
        _x.matchingPriority = matchingPriority;
        return _x;
    }

    @Property(name="source")
    @JsonIgnore
    public Optional<AttributeMappingSource> getSource() {
        return Optional.ofNullable(source);
    }

    public AttributeMapping withSource(AttributeMappingSource source) {
        AttributeMapping _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attributeMapping");
        _x.source = source;
        return _x;
    }

    @Property(name="targetAttributeName")
    @JsonIgnore
    public Optional<String> getTargetAttributeName() {
        return Optional.ofNullable(targetAttributeName);
    }

    public AttributeMapping withTargetAttributeName(String targetAttributeName) {
        AttributeMapping _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attributeMapping");
        _x.targetAttributeName = targetAttributeName;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String defaultValue;
        private Boolean exportMissingReferences;
        private AttributeFlowBehavior flowBehavior;
        private AttributeFlowType flowType;
        private Integer matchingPriority;
        private AttributeMappingSource source;
        private String targetAttributeName;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            this.changedFields = changedFields.add("defaultValue");
            return this;
        }

        public Builder exportMissingReferences(Boolean exportMissingReferences) {
            this.exportMissingReferences = exportMissingReferences;
            this.changedFields = changedFields.add("exportMissingReferences");
            return this;
        }

        public Builder flowBehavior(AttributeFlowBehavior flowBehavior) {
            this.flowBehavior = flowBehavior;
            this.changedFields = changedFields.add("flowBehavior");
            return this;
        }

        public Builder flowType(AttributeFlowType flowType) {
            this.flowType = flowType;
            this.changedFields = changedFields.add("flowType");
            return this;
        }

        public Builder matchingPriority(Integer matchingPriority) {
            this.matchingPriority = matchingPriority;
            this.changedFields = changedFields.add("matchingPriority");
            return this;
        }

        public Builder source(AttributeMappingSource source) {
            this.source = source;
            this.changedFields = changedFields.add("source");
            return this;
        }

        public Builder targetAttributeName(String targetAttributeName) {
            this.targetAttributeName = targetAttributeName;
            this.changedFields = changedFields.add("targetAttributeName");
            return this;
        }

        public AttributeMapping build() {
            AttributeMapping _x = new AttributeMapping();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.attributeMapping";
            _x.defaultValue = defaultValue;
            _x.exportMissingReferences = exportMissingReferences;
            _x.flowBehavior = flowBehavior;
            _x.flowType = flowType;
            _x.matchingPriority = matchingPriority;
            _x.source = source;
            _x.targetAttributeName = targetAttributeName;
            return _x;
        }
    }

    private AttributeMapping _copy() {
        AttributeMapping _x = new AttributeMapping();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.defaultValue = defaultValue;
        _x.exportMissingReferences = exportMissingReferences;
        _x.flowBehavior = flowBehavior;
        _x.flowType = flowType;
        _x.matchingPriority = matchingPriority;
        _x.source = source;
        _x.targetAttributeName = targetAttributeName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AttributeMapping[");
        b.append("defaultValue=");
        b.append(this.defaultValue);
        b.append(", ");
        b.append("exportMissingReferences=");
        b.append(this.exportMissingReferences);
        b.append(", ");
        b.append("flowBehavior=");
        b.append(this.flowBehavior);
        b.append(", ");
        b.append("flowType=");
        b.append(this.flowType);
        b.append(", ");
        b.append("matchingPriority=");
        b.append(this.matchingPriority);
        b.append(", ");
        b.append("source=");
        b.append(this.source);
        b.append(", ");
        b.append("targetAttributeName=");
        b.append(this.targetAttributeName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
