package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.AttributeType;
import odata.msgraph.client.beta.enums.Mutability;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "anchor", 
    "apiExpressions", 
    "caseExact", 
    "defaultValue", 
    "metadata", 
    "multivalued", 
    "mutability", 
    "name", 
    "required", 
    "referencedObjects", 
    "type"})
@JsonInclude(Include.NON_NULL)
public class AttributeDefinition implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("anchor")
    protected Boolean anchor;

    @JsonProperty("apiExpressions")
    protected List<StringKeyStringValuePair> apiExpressions;

    @JsonProperty("apiExpressions@nextLink")
    protected String apiExpressionsNextLink;

    @JsonProperty("caseExact")
    protected Boolean caseExact;

    @JsonProperty("defaultValue")
    protected String defaultValue;

    @JsonProperty("metadata")
    protected List<MetadataEntry> metadata;

    @JsonProperty("metadata@nextLink")
    protected String metadataNextLink;

    @JsonProperty("multivalued")
    protected Boolean multivalued;

    @JsonProperty("mutability")
    protected Mutability mutability;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("required")
    protected Boolean required;

    @JsonProperty("referencedObjects")
    protected List<ReferencedObject> referencedObjects;

    @JsonProperty("referencedObjects@nextLink")
    protected String referencedObjectsNextLink;

    @JsonProperty("type")
    protected AttributeType type;

    protected AttributeDefinition() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.attributeDefinition";
    }

    @Property(name="anchor")
    @JsonIgnore
    public Optional<Boolean> getAnchor() {
        return Optional.ofNullable(anchor);
    }

    public AttributeDefinition withAnchor(Boolean anchor) {
        AttributeDefinition _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attributeDefinition");
        _x.anchor = anchor;
        return _x;
    }

    @Property(name="apiExpressions")
    @JsonIgnore
    public CollectionPage<StringKeyStringValuePair> getApiExpressions() {
        return new CollectionPage<StringKeyStringValuePair>(contextPath, StringKeyStringValuePair.class, apiExpressions, Optional.ofNullable(apiExpressionsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="apiExpressions")
    @JsonIgnore
    public CollectionPage<StringKeyStringValuePair> getApiExpressions(HttpRequestOptions options) {
        return new CollectionPage<StringKeyStringValuePair>(contextPath, StringKeyStringValuePair.class, apiExpressions, Optional.ofNullable(apiExpressionsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="caseExact")
    @JsonIgnore
    public Optional<Boolean> getCaseExact() {
        return Optional.ofNullable(caseExact);
    }

    public AttributeDefinition withCaseExact(Boolean caseExact) {
        AttributeDefinition _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attributeDefinition");
        _x.caseExact = caseExact;
        return _x;
    }

    @Property(name="defaultValue")
    @JsonIgnore
    public Optional<String> getDefaultValue() {
        return Optional.ofNullable(defaultValue);
    }

    public AttributeDefinition withDefaultValue(String defaultValue) {
        AttributeDefinition _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attributeDefinition");
        _x.defaultValue = defaultValue;
        return _x;
    }

    @Property(name="metadata")
    @JsonIgnore
    public CollectionPage<MetadataEntry> getMetadata() {
        return new CollectionPage<MetadataEntry>(contextPath, MetadataEntry.class, metadata, Optional.ofNullable(metadataNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="metadata")
    @JsonIgnore
    public CollectionPage<MetadataEntry> getMetadata(HttpRequestOptions options) {
        return new CollectionPage<MetadataEntry>(contextPath, MetadataEntry.class, metadata, Optional.ofNullable(metadataNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="multivalued")
    @JsonIgnore
    public Optional<Boolean> getMultivalued() {
        return Optional.ofNullable(multivalued);
    }

    public AttributeDefinition withMultivalued(Boolean multivalued) {
        AttributeDefinition _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attributeDefinition");
        _x.multivalued = multivalued;
        return _x;
    }

    @Property(name="mutability")
    @JsonIgnore
    public Optional<Mutability> getMutability() {
        return Optional.ofNullable(mutability);
    }

    public AttributeDefinition withMutability(Mutability mutability) {
        AttributeDefinition _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attributeDefinition");
        _x.mutability = mutability;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public AttributeDefinition withName(String name) {
        AttributeDefinition _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attributeDefinition");
        _x.name = name;
        return _x;
    }

    @Property(name="required")
    @JsonIgnore
    public Optional<Boolean> getRequired() {
        return Optional.ofNullable(required);
    }

    public AttributeDefinition withRequired(Boolean required) {
        AttributeDefinition _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attributeDefinition");
        _x.required = required;
        return _x;
    }

    @Property(name="referencedObjects")
    @JsonIgnore
    public CollectionPage<ReferencedObject> getReferencedObjects() {
        return new CollectionPage<ReferencedObject>(contextPath, ReferencedObject.class, referencedObjects, Optional.ofNullable(referencedObjectsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="referencedObjects")
    @JsonIgnore
    public CollectionPage<ReferencedObject> getReferencedObjects(HttpRequestOptions options) {
        return new CollectionPage<ReferencedObject>(contextPath, ReferencedObject.class, referencedObjects, Optional.ofNullable(referencedObjectsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<AttributeType> getType() {
        return Optional.ofNullable(type);
    }

    public AttributeDefinition withType(AttributeType type) {
        AttributeDefinition _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attributeDefinition");
        _x.type = type;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean anchor;
        private List<StringKeyStringValuePair> apiExpressions;
        private String apiExpressionsNextLink;
        private Boolean caseExact;
        private String defaultValue;
        private List<MetadataEntry> metadata;
        private String metadataNextLink;
        private Boolean multivalued;
        private Mutability mutability;
        private String name;
        private Boolean required;
        private List<ReferencedObject> referencedObjects;
        private String referencedObjectsNextLink;
        private AttributeType type;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder anchor(Boolean anchor) {
            this.anchor = anchor;
            this.changedFields = changedFields.add("anchor");
            return this;
        }

        public Builder apiExpressions(List<StringKeyStringValuePair> apiExpressions) {
            this.apiExpressions = apiExpressions;
            this.changedFields = changedFields.add("apiExpressions");
            return this;
        }

        public Builder apiExpressions(StringKeyStringValuePair... apiExpressions) {
            return apiExpressions(Arrays.asList(apiExpressions));
        }

        public Builder apiExpressionsNextLink(String apiExpressionsNextLink) {
            this.apiExpressionsNextLink = apiExpressionsNextLink;
            this.changedFields = changedFields.add("apiExpressions");
            return this;
        }

        public Builder caseExact(Boolean caseExact) {
            this.caseExact = caseExact;
            this.changedFields = changedFields.add("caseExact");
            return this;
        }

        public Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            this.changedFields = changedFields.add("defaultValue");
            return this;
        }

        public Builder metadata(List<MetadataEntry> metadata) {
            this.metadata = metadata;
            this.changedFields = changedFields.add("metadata");
            return this;
        }

        public Builder metadata(MetadataEntry... metadata) {
            return metadata(Arrays.asList(metadata));
        }

        public Builder metadataNextLink(String metadataNextLink) {
            this.metadataNextLink = metadataNextLink;
            this.changedFields = changedFields.add("metadata");
            return this;
        }

        public Builder multivalued(Boolean multivalued) {
            this.multivalued = multivalued;
            this.changedFields = changedFields.add("multivalued");
            return this;
        }

        public Builder mutability(Mutability mutability) {
            this.mutability = mutability;
            this.changedFields = changedFields.add("mutability");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder required(Boolean required) {
            this.required = required;
            this.changedFields = changedFields.add("required");
            return this;
        }

        public Builder referencedObjects(List<ReferencedObject> referencedObjects) {
            this.referencedObjects = referencedObjects;
            this.changedFields = changedFields.add("referencedObjects");
            return this;
        }

        public Builder referencedObjects(ReferencedObject... referencedObjects) {
            return referencedObjects(Arrays.asList(referencedObjects));
        }

        public Builder referencedObjectsNextLink(String referencedObjectsNextLink) {
            this.referencedObjectsNextLink = referencedObjectsNextLink;
            this.changedFields = changedFields.add("referencedObjects");
            return this;
        }

        public Builder type(AttributeType type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public AttributeDefinition build() {
            AttributeDefinition _x = new AttributeDefinition();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.attributeDefinition";
            _x.anchor = anchor;
            _x.apiExpressions = apiExpressions;
            _x.apiExpressionsNextLink = apiExpressionsNextLink;
            _x.caseExact = caseExact;
            _x.defaultValue = defaultValue;
            _x.metadata = metadata;
            _x.metadataNextLink = metadataNextLink;
            _x.multivalued = multivalued;
            _x.mutability = mutability;
            _x.name = name;
            _x.required = required;
            _x.referencedObjects = referencedObjects;
            _x.referencedObjectsNextLink = referencedObjectsNextLink;
            _x.type = type;
            return _x;
        }
    }

    private AttributeDefinition _copy() {
        AttributeDefinition _x = new AttributeDefinition();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.anchor = anchor;
        _x.apiExpressions = apiExpressions;
        _x.caseExact = caseExact;
        _x.defaultValue = defaultValue;
        _x.metadata = metadata;
        _x.multivalued = multivalued;
        _x.mutability = mutability;
        _x.name = name;
        _x.required = required;
        _x.referencedObjects = referencedObjects;
        _x.type = type;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AttributeDefinition[");
        b.append("anchor=");
        b.append(this.anchor);
        b.append(", ");
        b.append("apiExpressions=");
        b.append(this.apiExpressions);
        b.append(", ");
        b.append("caseExact=");
        b.append(this.caseExact);
        b.append(", ");
        b.append("defaultValue=");
        b.append(this.defaultValue);
        b.append(", ");
        b.append("metadata=");
        b.append(this.metadata);
        b.append(", ");
        b.append("multivalued=");
        b.append(this.multivalued);
        b.append(", ");
        b.append("mutability=");
        b.append(this.mutability);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("required=");
        b.append(this.required);
        b.append(", ");
        b.append("referencedObjects=");
        b.append(this.referencedObjects);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
