package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.FreeBusyStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "attendee", 
    "availability"})
@JsonInclude(Include.NON_NULL)
public class AttendeeAvailability implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("attendee")
    protected AttendeeBase attendee;

    @JsonProperty("availability")
    protected FreeBusyStatus availability;

    protected AttendeeAvailability() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.attendeeAvailability";
    }

    @Property(name="attendee")
    @JsonIgnore
    public Optional<AttendeeBase> getAttendee() {
        return Optional.ofNullable(attendee);
    }

    public AttendeeAvailability withAttendee(AttendeeBase attendee) {
        AttendeeAvailability _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attendeeAvailability");
        _x.attendee = attendee;
        return _x;
    }

    @Property(name="availability")
    @JsonIgnore
    public Optional<FreeBusyStatus> getAvailability() {
        return Optional.ofNullable(availability);
    }

    public AttendeeAvailability withAvailability(FreeBusyStatus availability) {
        AttendeeAvailability _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.attendeeAvailability");
        _x.availability = availability;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private AttendeeBase attendee;
        private FreeBusyStatus availability;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder attendee(AttendeeBase attendee) {
            this.attendee = attendee;
            this.changedFields = changedFields.add("attendee");
            return this;
        }

        public Builder availability(FreeBusyStatus availability) {
            this.availability = availability;
            this.changedFields = changedFields.add("availability");
            return this;
        }

        public AttendeeAvailability build() {
            AttendeeAvailability _x = new AttendeeAvailability();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.attendeeAvailability";
            _x.attendee = attendee;
            _x.availability = availability;
            return _x;
        }
    }

    private AttendeeAvailability _copy() {
        AttendeeAvailability _x = new AttendeeAvailability();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.attendee = attendee;
        _x.availability = availability;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AttendeeAvailability[");
        b.append("attendee=");
        b.append(this.attendee);
        b.append(", ");
        b.append("availability=");
        b.append(this.availability);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
