package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "isEnabled", 
    "recurrenceType", 
    "reviewerType", 
    "startDateTime", 
    "durationInDays", 
    "reviewers"})
@JsonInclude(Include.NON_NULL)
public class AssignmentReviewSettings implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("isEnabled")
    protected Boolean isEnabled;

    @JsonProperty("recurrenceType")
    protected String recurrenceType;

    @JsonProperty("reviewerType")
    protected String reviewerType;

    @JsonProperty("startDateTime")
    protected OffsetDateTime startDateTime;

    @JsonProperty("durationInDays")
    protected Integer durationInDays;

    @JsonProperty("reviewers")
    protected List<UserSet> reviewers;

    @JsonProperty("reviewers@nextLink")
    protected String reviewersNextLink;

    protected AssignmentReviewSettings() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.assignmentReviewSettings";
    }

    @Property(name="isEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsEnabled() {
        return Optional.ofNullable(isEnabled);
    }

    public AssignmentReviewSettings withIsEnabled(Boolean isEnabled) {
        AssignmentReviewSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.assignmentReviewSettings");
        _x.isEnabled = isEnabled;
        return _x;
    }

    @Property(name="recurrenceType")
    @JsonIgnore
    public Optional<String> getRecurrenceType() {
        return Optional.ofNullable(recurrenceType);
    }

    public AssignmentReviewSettings withRecurrenceType(String recurrenceType) {
        AssignmentReviewSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.assignmentReviewSettings");
        _x.recurrenceType = recurrenceType;
        return _x;
    }

    @Property(name="reviewerType")
    @JsonIgnore
    public Optional<String> getReviewerType() {
        return Optional.ofNullable(reviewerType);
    }

    public AssignmentReviewSettings withReviewerType(String reviewerType) {
        AssignmentReviewSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.assignmentReviewSettings");
        _x.reviewerType = reviewerType;
        return _x;
    }

    @Property(name="startDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartDateTime() {
        return Optional.ofNullable(startDateTime);
    }

    public AssignmentReviewSettings withStartDateTime(OffsetDateTime startDateTime) {
        AssignmentReviewSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.assignmentReviewSettings");
        _x.startDateTime = startDateTime;
        return _x;
    }

    @Property(name="durationInDays")
    @JsonIgnore
    public Optional<Integer> getDurationInDays() {
        return Optional.ofNullable(durationInDays);
    }

    public AssignmentReviewSettings withDurationInDays(Integer durationInDays) {
        AssignmentReviewSettings _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.assignmentReviewSettings");
        _x.durationInDays = durationInDays;
        return _x;
    }

    @Property(name="reviewers")
    @JsonIgnore
    public CollectionPage<UserSet> getReviewers() {
        return new CollectionPage<UserSet>(contextPath, UserSet.class, reviewers, Optional.ofNullable(reviewersNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="reviewers")
    @JsonIgnore
    public CollectionPage<UserSet> getReviewers(HttpRequestOptions options) {
        return new CollectionPage<UserSet>(contextPath, UserSet.class, reviewers, Optional.ofNullable(reviewersNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean isEnabled;
        private String recurrenceType;
        private String reviewerType;
        private OffsetDateTime startDateTime;
        private Integer durationInDays;
        private List<UserSet> reviewers;
        private String reviewersNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.changedFields = changedFields.add("isEnabled");
            return this;
        }

        public Builder recurrenceType(String recurrenceType) {
            this.recurrenceType = recurrenceType;
            this.changedFields = changedFields.add("recurrenceType");
            return this;
        }

        public Builder reviewerType(String reviewerType) {
            this.reviewerType = reviewerType;
            this.changedFields = changedFields.add("reviewerType");
            return this;
        }

        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        public Builder durationInDays(Integer durationInDays) {
            this.durationInDays = durationInDays;
            this.changedFields = changedFields.add("durationInDays");
            return this;
        }

        public Builder reviewers(List<UserSet> reviewers) {
            this.reviewers = reviewers;
            this.changedFields = changedFields.add("reviewers");
            return this;
        }

        public Builder reviewers(UserSet... reviewers) {
            return reviewers(Arrays.asList(reviewers));
        }

        public Builder reviewersNextLink(String reviewersNextLink) {
            this.reviewersNextLink = reviewersNextLink;
            this.changedFields = changedFields.add("reviewers");
            return this;
        }

        public AssignmentReviewSettings build() {
            AssignmentReviewSettings _x = new AssignmentReviewSettings();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.assignmentReviewSettings";
            _x.isEnabled = isEnabled;
            _x.recurrenceType = recurrenceType;
            _x.reviewerType = reviewerType;
            _x.startDateTime = startDateTime;
            _x.durationInDays = durationInDays;
            _x.reviewers = reviewers;
            _x.reviewersNextLink = reviewersNextLink;
            return _x;
        }
    }

    private AssignmentReviewSettings _copy() {
        AssignmentReviewSettings _x = new AssignmentReviewSettings();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.isEnabled = isEnabled;
        _x.recurrenceType = recurrenceType;
        _x.reviewerType = reviewerType;
        _x.startDateTime = startDateTime;
        _x.durationInDays = durationInDays;
        _x.reviewers = reviewers;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AssignmentReviewSettings[");
        b.append("isEnabled=");
        b.append(this.isEnabled);
        b.append(", ");
        b.append("recurrenceType=");
        b.append(this.recurrenceType);
        b.append(", ");
        b.append("reviewerType=");
        b.append(this.reviewerType);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("durationInDays=");
        b.append(this.durationInDays);
        b.append(", ");
        b.append("reviewers=");
        b.append(this.reviewers);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
