package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "disabledPlans", 
    "skuId"})
@JsonInclude(Include.NON_NULL)
public class AssignedLicense implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("disabledPlans")
    protected List<String> disabledPlans;

    @JsonProperty("disabledPlans@nextLink")
    protected String disabledPlansNextLink;

    @JsonProperty("skuId")
    protected String skuId;

    protected AssignedLicense() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.assignedLicense";
    }

    @Property(name="disabledPlans")
    @JsonIgnore
    public CollectionPage<String> getDisabledPlans() {
        return new CollectionPage<String>(contextPath, String.class, disabledPlans, Optional.ofNullable(disabledPlansNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="disabledPlans")
    @JsonIgnore
    public CollectionPage<String> getDisabledPlans(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, disabledPlans, Optional.ofNullable(disabledPlansNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="skuId")
    @JsonIgnore
    public Optional<String> getSkuId() {
        return Optional.ofNullable(skuId);
    }

    public AssignedLicense withSkuId(String skuId) {
        AssignedLicense _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.assignedLicense");
        _x.skuId = skuId;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> disabledPlans;
        private String disabledPlansNextLink;
        private String skuId;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder disabledPlans(List<String> disabledPlans) {
            this.disabledPlans = disabledPlans;
            this.changedFields = changedFields.add("disabledPlans");
            return this;
        }

        public Builder disabledPlans(String... disabledPlans) {
            return disabledPlans(Arrays.asList(disabledPlans));
        }

        public Builder disabledPlansNextLink(String disabledPlansNextLink) {
            this.disabledPlansNextLink = disabledPlansNextLink;
            this.changedFields = changedFields.add("disabledPlans");
            return this;
        }

        public Builder skuId(String skuId) {
            this.skuId = skuId;
            this.changedFields = changedFields.add("skuId");
            return this;
        }

        public AssignedLicense build() {
            AssignedLicense _x = new AssignedLicense();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.assignedLicense";
            _x.disabledPlans = disabledPlans;
            _x.disabledPlansNextLink = disabledPlansNextLink;
            _x.skuId = skuId;
            return _x;
        }
    }

    private AssignedLicense _copy() {
        AssignedLicense _x = new AssignedLicense();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.disabledPlans = disabledPlans;
        _x.skuId = skuId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AssignedLicense[");
        b.append("disabledPlans=");
        b.append(this.disabledPlans);
        b.append(", ");
        b.append("skuId=");
        b.append(this.skuId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
