package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "approvalStageTimeOutInDays", 
    "isApproverJustificationRequired", 
    "isEscalationEnabled", 
    "escalationTimeInMinutes", 
    "primaryApprovers", 
    "escalationApprovers"})
@JsonInclude(Include.NON_NULL)
public class ApprovalStage implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("approvalStageTimeOutInDays")
    protected Integer approvalStageTimeOutInDays;

    @JsonProperty("isApproverJustificationRequired")
    protected Boolean isApproverJustificationRequired;

    @JsonProperty("isEscalationEnabled")
    protected Boolean isEscalationEnabled;

    @JsonProperty("escalationTimeInMinutes")
    protected Integer escalationTimeInMinutes;

    @JsonProperty("primaryApprovers")
    protected List<UserSet> primaryApprovers;

    @JsonProperty("primaryApprovers@nextLink")
    protected String primaryApproversNextLink;

    @JsonProperty("escalationApprovers")
    protected List<UserSet> escalationApprovers;

    @JsonProperty("escalationApprovers@nextLink")
    protected String escalationApproversNextLink;

    protected ApprovalStage() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.approvalStage";
    }

    @Property(name="approvalStageTimeOutInDays")
    @JsonIgnore
    public Optional<Integer> getApprovalStageTimeOutInDays() {
        return Optional.ofNullable(approvalStageTimeOutInDays);
    }

    public ApprovalStage withApprovalStageTimeOutInDays(Integer approvalStageTimeOutInDays) {
        ApprovalStage _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.approvalStage");
        _x.approvalStageTimeOutInDays = approvalStageTimeOutInDays;
        return _x;
    }

    @Property(name="isApproverJustificationRequired")
    @JsonIgnore
    public Optional<Boolean> getIsApproverJustificationRequired() {
        return Optional.ofNullable(isApproverJustificationRequired);
    }

    public ApprovalStage withIsApproverJustificationRequired(Boolean isApproverJustificationRequired) {
        ApprovalStage _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.approvalStage");
        _x.isApproverJustificationRequired = isApproverJustificationRequired;
        return _x;
    }

    @Property(name="isEscalationEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsEscalationEnabled() {
        return Optional.ofNullable(isEscalationEnabled);
    }

    public ApprovalStage withIsEscalationEnabled(Boolean isEscalationEnabled) {
        ApprovalStage _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.approvalStage");
        _x.isEscalationEnabled = isEscalationEnabled;
        return _x;
    }

    @Property(name="escalationTimeInMinutes")
    @JsonIgnore
    public Optional<Integer> getEscalationTimeInMinutes() {
        return Optional.ofNullable(escalationTimeInMinutes);
    }

    public ApprovalStage withEscalationTimeInMinutes(Integer escalationTimeInMinutes) {
        ApprovalStage _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.approvalStage");
        _x.escalationTimeInMinutes = escalationTimeInMinutes;
        return _x;
    }

    @Property(name="primaryApprovers")
    @JsonIgnore
    public CollectionPage<UserSet> getPrimaryApprovers() {
        return new CollectionPage<UserSet>(contextPath, UserSet.class, primaryApprovers, Optional.ofNullable(primaryApproversNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="primaryApprovers")
    @JsonIgnore
    public CollectionPage<UserSet> getPrimaryApprovers(HttpRequestOptions options) {
        return new CollectionPage<UserSet>(contextPath, UserSet.class, primaryApprovers, Optional.ofNullable(primaryApproversNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="escalationApprovers")
    @JsonIgnore
    public CollectionPage<UserSet> getEscalationApprovers() {
        return new CollectionPage<UserSet>(contextPath, UserSet.class, escalationApprovers, Optional.ofNullable(escalationApproversNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="escalationApprovers")
    @JsonIgnore
    public CollectionPage<UserSet> getEscalationApprovers(HttpRequestOptions options) {
        return new CollectionPage<UserSet>(contextPath, UserSet.class, escalationApprovers, Optional.ofNullable(escalationApproversNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer approvalStageTimeOutInDays;
        private Boolean isApproverJustificationRequired;
        private Boolean isEscalationEnabled;
        private Integer escalationTimeInMinutes;
        private List<UserSet> primaryApprovers;
        private String primaryApproversNextLink;
        private List<UserSet> escalationApprovers;
        private String escalationApproversNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder approvalStageTimeOutInDays(Integer approvalStageTimeOutInDays) {
            this.approvalStageTimeOutInDays = approvalStageTimeOutInDays;
            this.changedFields = changedFields.add("approvalStageTimeOutInDays");
            return this;
        }

        public Builder isApproverJustificationRequired(Boolean isApproverJustificationRequired) {
            this.isApproverJustificationRequired = isApproverJustificationRequired;
            this.changedFields = changedFields.add("isApproverJustificationRequired");
            return this;
        }

        public Builder isEscalationEnabled(Boolean isEscalationEnabled) {
            this.isEscalationEnabled = isEscalationEnabled;
            this.changedFields = changedFields.add("isEscalationEnabled");
            return this;
        }

        public Builder escalationTimeInMinutes(Integer escalationTimeInMinutes) {
            this.escalationTimeInMinutes = escalationTimeInMinutes;
            this.changedFields = changedFields.add("escalationTimeInMinutes");
            return this;
        }

        public Builder primaryApprovers(List<UserSet> primaryApprovers) {
            this.primaryApprovers = primaryApprovers;
            this.changedFields = changedFields.add("primaryApprovers");
            return this;
        }

        public Builder primaryApprovers(UserSet... primaryApprovers) {
            return primaryApprovers(Arrays.asList(primaryApprovers));
        }

        public Builder primaryApproversNextLink(String primaryApproversNextLink) {
            this.primaryApproversNextLink = primaryApproversNextLink;
            this.changedFields = changedFields.add("primaryApprovers");
            return this;
        }

        public Builder escalationApprovers(List<UserSet> escalationApprovers) {
            this.escalationApprovers = escalationApprovers;
            this.changedFields = changedFields.add("escalationApprovers");
            return this;
        }

        public Builder escalationApprovers(UserSet... escalationApprovers) {
            return escalationApprovers(Arrays.asList(escalationApprovers));
        }

        public Builder escalationApproversNextLink(String escalationApproversNextLink) {
            this.escalationApproversNextLink = escalationApproversNextLink;
            this.changedFields = changedFields.add("escalationApprovers");
            return this;
        }

        public ApprovalStage build() {
            ApprovalStage _x = new ApprovalStage();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.approvalStage";
            _x.approvalStageTimeOutInDays = approvalStageTimeOutInDays;
            _x.isApproverJustificationRequired = isApproverJustificationRequired;
            _x.isEscalationEnabled = isEscalationEnabled;
            _x.escalationTimeInMinutes = escalationTimeInMinutes;
            _x.primaryApprovers = primaryApprovers;
            _x.primaryApproversNextLink = primaryApproversNextLink;
            _x.escalationApprovers = escalationApprovers;
            _x.escalationApproversNextLink = escalationApproversNextLink;
            return _x;
        }
    }

    private ApprovalStage _copy() {
        ApprovalStage _x = new ApprovalStage();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.approvalStageTimeOutInDays = approvalStageTimeOutInDays;
        _x.isApproverJustificationRequired = isApproverJustificationRequired;
        _x.isEscalationEnabled = isEscalationEnabled;
        _x.escalationTimeInMinutes = escalationTimeInMinutes;
        _x.primaryApprovers = primaryApprovers;
        _x.escalationApprovers = escalationApprovers;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ApprovalStage[");
        b.append("approvalStageTimeOutInDays=");
        b.append(this.approvalStageTimeOutInDays);
        b.append(", ");
        b.append("isApproverJustificationRequired=");
        b.append(this.isApproverJustificationRequired);
        b.append(", ");
        b.append("isEscalationEnabled=");
        b.append(this.isEscalationEnabled);
        b.append(", ");
        b.append("escalationTimeInMinutes=");
        b.append(this.escalationTimeInMinutes);
        b.append(", ");
        b.append("primaryApprovers=");
        b.append(this.primaryApprovers);
        b.append(", ");
        b.append("escalationApprovers=");
        b.append(this.escalationApprovers);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
