package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.AppliedConditionalAccessPolicyResult;
import odata.msgraph.client.beta.enums.ConditionalAccessConditions;

@JsonPropertyOrder({
    "@odata.type", 
    "id", 
    "displayName", 
    "enforcedGrantControls", 
    "enforcedSessionControls", 
    "conditionsSatisfied", 
    "conditionsNotSatisfied", 
    "result"})
@JsonInclude(Include.NON_NULL)
public class AppliedConditionalAccessPolicy implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("id")
    protected String id;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("enforcedGrantControls")
    protected List<String> enforcedGrantControls;

    @JsonProperty("enforcedGrantControls@nextLink")
    protected String enforcedGrantControlsNextLink;

    @JsonProperty("enforcedSessionControls")
    protected List<String> enforcedSessionControls;

    @JsonProperty("enforcedSessionControls@nextLink")
    protected String enforcedSessionControlsNextLink;

    @JsonProperty("conditionsSatisfied")
    protected ConditionalAccessConditions conditionsSatisfied;

    @JsonProperty("conditionsNotSatisfied")
    protected ConditionalAccessConditions conditionsNotSatisfied;

    @JsonProperty("result")
    protected AppliedConditionalAccessPolicyResult result;

    protected AppliedConditionalAccessPolicy() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.appliedConditionalAccessPolicy";
    }

    @Property(name="id")
    @JsonIgnore
    public Optional<String> getId() {
        return Optional.ofNullable(id);
    }

    public AppliedConditionalAccessPolicy withId(String id) {
        AppliedConditionalAccessPolicy _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appliedConditionalAccessPolicy");
        _x.id = id;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public AppliedConditionalAccessPolicy withDisplayName(String displayName) {
        AppliedConditionalAccessPolicy _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appliedConditionalAccessPolicy");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="enforcedGrantControls")
    @JsonIgnore
    public CollectionPage<String> getEnforcedGrantControls() {
        return new CollectionPage<String>(contextPath, String.class, enforcedGrantControls, Optional.ofNullable(enforcedGrantControlsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="enforcedGrantControls")
    @JsonIgnore
    public CollectionPage<String> getEnforcedGrantControls(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, enforcedGrantControls, Optional.ofNullable(enforcedGrantControlsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="enforcedSessionControls")
    @JsonIgnore
    public CollectionPage<String> getEnforcedSessionControls() {
        return new CollectionPage<String>(contextPath, String.class, enforcedSessionControls, Optional.ofNullable(enforcedSessionControlsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="enforcedSessionControls")
    @JsonIgnore
    public CollectionPage<String> getEnforcedSessionControls(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, enforcedSessionControls, Optional.ofNullable(enforcedSessionControlsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="conditionsSatisfied")
    @JsonIgnore
    public Optional<ConditionalAccessConditions> getConditionsSatisfied() {
        return Optional.ofNullable(conditionsSatisfied);
    }

    public AppliedConditionalAccessPolicy withConditionsSatisfied(ConditionalAccessConditions conditionsSatisfied) {
        AppliedConditionalAccessPolicy _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appliedConditionalAccessPolicy");
        _x.conditionsSatisfied = conditionsSatisfied;
        return _x;
    }

    @Property(name="conditionsNotSatisfied")
    @JsonIgnore
    public Optional<ConditionalAccessConditions> getConditionsNotSatisfied() {
        return Optional.ofNullable(conditionsNotSatisfied);
    }

    public AppliedConditionalAccessPolicy withConditionsNotSatisfied(ConditionalAccessConditions conditionsNotSatisfied) {
        AppliedConditionalAccessPolicy _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appliedConditionalAccessPolicy");
        _x.conditionsNotSatisfied = conditionsNotSatisfied;
        return _x;
    }

    @Property(name="result")
    @JsonIgnore
    public Optional<AppliedConditionalAccessPolicyResult> getResult() {
        return Optional.ofNullable(result);
    }

    public AppliedConditionalAccessPolicy withResult(AppliedConditionalAccessPolicyResult result) {
        AppliedConditionalAccessPolicy _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appliedConditionalAccessPolicy");
        _x.result = result;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private List<String> enforcedGrantControls;
        private String enforcedGrantControlsNextLink;
        private List<String> enforcedSessionControls;
        private String enforcedSessionControlsNextLink;
        private ConditionalAccessConditions conditionsSatisfied;
        private ConditionalAccessConditions conditionsNotSatisfied;
        private AppliedConditionalAccessPolicyResult result;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder enforcedGrantControls(List<String> enforcedGrantControls) {
            this.enforcedGrantControls = enforcedGrantControls;
            this.changedFields = changedFields.add("enforcedGrantControls");
            return this;
        }

        public Builder enforcedGrantControls(String... enforcedGrantControls) {
            return enforcedGrantControls(Arrays.asList(enforcedGrantControls));
        }

        public Builder enforcedGrantControlsNextLink(String enforcedGrantControlsNextLink) {
            this.enforcedGrantControlsNextLink = enforcedGrantControlsNextLink;
            this.changedFields = changedFields.add("enforcedGrantControls");
            return this;
        }

        public Builder enforcedSessionControls(List<String> enforcedSessionControls) {
            this.enforcedSessionControls = enforcedSessionControls;
            this.changedFields = changedFields.add("enforcedSessionControls");
            return this;
        }

        public Builder enforcedSessionControls(String... enforcedSessionControls) {
            return enforcedSessionControls(Arrays.asList(enforcedSessionControls));
        }

        public Builder enforcedSessionControlsNextLink(String enforcedSessionControlsNextLink) {
            this.enforcedSessionControlsNextLink = enforcedSessionControlsNextLink;
            this.changedFields = changedFields.add("enforcedSessionControls");
            return this;
        }

        public Builder conditionsSatisfied(ConditionalAccessConditions conditionsSatisfied) {
            this.conditionsSatisfied = conditionsSatisfied;
            this.changedFields = changedFields.add("conditionsSatisfied");
            return this;
        }

        public Builder conditionsNotSatisfied(ConditionalAccessConditions conditionsNotSatisfied) {
            this.conditionsNotSatisfied = conditionsNotSatisfied;
            this.changedFields = changedFields.add("conditionsNotSatisfied");
            return this;
        }

        public Builder result(AppliedConditionalAccessPolicyResult result) {
            this.result = result;
            this.changedFields = changedFields.add("result");
            return this;
        }

        public AppliedConditionalAccessPolicy build() {
            AppliedConditionalAccessPolicy _x = new AppliedConditionalAccessPolicy();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.appliedConditionalAccessPolicy";
            _x.id = id;
            _x.displayName = displayName;
            _x.enforcedGrantControls = enforcedGrantControls;
            _x.enforcedGrantControlsNextLink = enforcedGrantControlsNextLink;
            _x.enforcedSessionControls = enforcedSessionControls;
            _x.enforcedSessionControlsNextLink = enforcedSessionControlsNextLink;
            _x.conditionsSatisfied = conditionsSatisfied;
            _x.conditionsNotSatisfied = conditionsNotSatisfied;
            _x.result = result;
            return _x;
        }
    }

    private AppliedConditionalAccessPolicy _copy() {
        AppliedConditionalAccessPolicy _x = new AppliedConditionalAccessPolicy();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.enforcedGrantControls = enforcedGrantControls;
        _x.enforcedSessionControls = enforcedSessionControls;
        _x.conditionsSatisfied = conditionsSatisfied;
        _x.conditionsNotSatisfied = conditionsNotSatisfied;
        _x.result = result;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AppliedConditionalAccessPolicy[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("enforcedGrantControls=");
        b.append(this.enforcedGrantControls);
        b.append(", ");
        b.append("enforcedSessionControls=");
        b.append(this.enforcedSessionControls);
        b.append(", ");
        b.append("conditionsSatisfied=");
        b.append(this.conditionsSatisfied);
        b.append(", ");
        b.append("conditionsNotSatisfied=");
        b.append(this.conditionsNotSatisfied);
        b.append(", ");
        b.append("result=");
        b.append(this.result);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
