package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.entity.Application;
import odata.msgraph.client.beta.entity.ServicePrincipal;

@JsonPropertyOrder({
    "@odata.type", 
    "application", 
    "servicePrincipal"})
@JsonInclude(Include.NON_NULL)
public class ApplicationServicePrincipal implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("application")
    protected Application application;

    @JsonProperty("servicePrincipal")
    protected ServicePrincipal servicePrincipal;

    protected ApplicationServicePrincipal() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.applicationServicePrincipal";
    }

    @Property(name="application")
    @JsonIgnore
    public Optional<Application> getApplication() {
        return Optional.ofNullable(application);
    }

    public ApplicationServicePrincipal withApplication(Application application) {
        ApplicationServicePrincipal _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.applicationServicePrincipal");
        _x.application = application;
        return _x;
    }

    @Property(name="servicePrincipal")
    @JsonIgnore
    public Optional<ServicePrincipal> getServicePrincipal() {
        return Optional.ofNullable(servicePrincipal);
    }

    public ApplicationServicePrincipal withServicePrincipal(ServicePrincipal servicePrincipal) {
        ApplicationServicePrincipal _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.applicationServicePrincipal");
        _x.servicePrincipal = servicePrincipal;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Application application;
        private ServicePrincipal servicePrincipal;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder application(Application application) {
            this.application = application;
            this.changedFields = changedFields.add("application");
            return this;
        }

        public Builder servicePrincipal(ServicePrincipal servicePrincipal) {
            this.servicePrincipal = servicePrincipal;
            this.changedFields = changedFields.add("servicePrincipal");
            return this;
        }

        public ApplicationServicePrincipal build() {
            ApplicationServicePrincipal _x = new ApplicationServicePrincipal();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.applicationServicePrincipal";
            _x.application = application;
            _x.servicePrincipal = servicePrincipal;
            return _x;
        }
    }

    private ApplicationServicePrincipal _copy() {
        ApplicationServicePrincipal _x = new ApplicationServicePrincipal();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.application = application;
        _x.servicePrincipal = servicePrincipal;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ApplicationServicePrincipal[");
        b.append("application=");
        b.append(this.application);
        b.append(", ");
        b.append("servicePrincipal=");
        b.append(this.servicePrincipal);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
