package odata.msgraph.client.beta.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.enums.VpnServiceExceptionAction;
import odata.msgraph.client.beta.enums.VpnTunnelConfigurationType;


/**
 * <i>“Always On VPN configuration for MacOS and iOS IKEv2”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "tunnelConfiguration", 
    "userToggleEnabled", 
    "voicemailExceptionAction", 
    "airPrintExceptionAction", 
    "cellularExceptionAction", 
    "allowAllCaptiveNetworkPlugins", 
    "allowedCaptiveNetworkPlugins", 
    "allowCaptiveWebSheet", 
    "natKeepAliveIntervalInSeconds", 
    "natKeepAliveOffloadEnable"})
@JsonInclude(Include.NON_NULL)
public class AppleVpnAlwaysOnConfiguration implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("tunnelConfiguration")
    protected VpnTunnelConfigurationType tunnelConfiguration;

    @JsonProperty("userToggleEnabled")
    protected Boolean userToggleEnabled;

    @JsonProperty("voicemailExceptionAction")
    protected VpnServiceExceptionAction voicemailExceptionAction;

    @JsonProperty("airPrintExceptionAction")
    protected VpnServiceExceptionAction airPrintExceptionAction;

    @JsonProperty("cellularExceptionAction")
    protected VpnServiceExceptionAction cellularExceptionAction;

    @JsonProperty("allowAllCaptiveNetworkPlugins")
    protected Boolean allowAllCaptiveNetworkPlugins;

    @JsonProperty("allowedCaptiveNetworkPlugins")
    protected SpecifiedCaptiveNetworkPlugins allowedCaptiveNetworkPlugins;

    @JsonProperty("allowCaptiveWebSheet")
    protected Boolean allowCaptiveWebSheet;

    @JsonProperty("natKeepAliveIntervalInSeconds")
    protected Integer natKeepAliveIntervalInSeconds;

    @JsonProperty("natKeepAliveOffloadEnable")
    protected Boolean natKeepAliveOffloadEnable;

    protected AppleVpnAlwaysOnConfiguration() {
    }

    @Override
    public String odataTypeName() {
        return "microsoft.graph.appleVpnAlwaysOnConfiguration";
    }

    /**
     * <i>“Determines what connections the specific tunnel configuration applies to”</i>
     * 
     * @return property tunnelConfiguration
     */
    @Property(name="tunnelConfiguration")
    @JsonIgnore
    public Optional<VpnTunnelConfigurationType> getTunnelConfiguration() {
        return Optional.ofNullable(tunnelConfiguration);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * tunnelConfiguration} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Determines what connections the specific tunnel configuration applies to”</i>
     * 
     * @param tunnelConfiguration
     *            new value of {@code tunnelConfiguration} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code tunnelConfiguration} field changed
     */
    public AppleVpnAlwaysOnConfiguration withTunnelConfiguration(VpnTunnelConfigurationType tunnelConfiguration) {
        AppleVpnAlwaysOnConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appleVpnAlwaysOnConfiguration");
        _x.tunnelConfiguration = tunnelConfiguration;
        return _x;
    }

    /**
     * <i>“Allow the user to toggle the VPN configuration using the UI”</i>
     * 
     * @return property userToggleEnabled
     */
    @Property(name="userToggleEnabled")
    @JsonIgnore
    public Optional<Boolean> getUserToggleEnabled() {
        return Optional.ofNullable(userToggleEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userToggleEnabled
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Allow the user to toggle the VPN configuration using the UI”</i>
     * 
     * @param userToggleEnabled
     *            new value of {@code userToggleEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userToggleEnabled} field changed
     */
    public AppleVpnAlwaysOnConfiguration withUserToggleEnabled(Boolean userToggleEnabled) {
        AppleVpnAlwaysOnConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appleVpnAlwaysOnConfiguration");
        _x.userToggleEnabled = userToggleEnabled;
        return _x;
    }

    /**
     * <i>“Determine whether voicemail service will be exempt from the always-on VPN
     * connection”</i>
     * 
     * @return property voicemailExceptionAction
     */
    @Property(name="voicemailExceptionAction")
    @JsonIgnore
    public Optional<VpnServiceExceptionAction> getVoicemailExceptionAction() {
        return Optional.ofNullable(voicemailExceptionAction);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * voicemailExceptionAction} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Determine whether voicemail service will be exempt from the always-on VPN
     * connection”</i>
     * 
     * @param voicemailExceptionAction
     *            new value of {@code voicemailExceptionAction} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code voicemailExceptionAction} field changed
     */
    public AppleVpnAlwaysOnConfiguration withVoicemailExceptionAction(VpnServiceExceptionAction voicemailExceptionAction) {
        AppleVpnAlwaysOnConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appleVpnAlwaysOnConfiguration");
        _x.voicemailExceptionAction = voicemailExceptionAction;
        return _x;
    }

    /**
     * <i>“Determine whether AirPrint service will be exempt from the always-on VPN
     * connection”</i>
     * 
     * @return property airPrintExceptionAction
     */
    @Property(name="airPrintExceptionAction")
    @JsonIgnore
    public Optional<VpnServiceExceptionAction> getAirPrintExceptionAction() {
        return Optional.ofNullable(airPrintExceptionAction);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * airPrintExceptionAction} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Determine whether AirPrint service will be exempt from the always-on VPN
     * connection”</i>
     * 
     * @param airPrintExceptionAction
     *            new value of {@code airPrintExceptionAction} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code airPrintExceptionAction} field changed
     */
    public AppleVpnAlwaysOnConfiguration withAirPrintExceptionAction(VpnServiceExceptionAction airPrintExceptionAction) {
        AppleVpnAlwaysOnConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appleVpnAlwaysOnConfiguration");
        _x.airPrintExceptionAction = airPrintExceptionAction;
        return _x;
    }

    /**
     * <i>“Determine whether Cellular service will be exempt from the always-on VPN
     * connection”</i>
     * 
     * @return property cellularExceptionAction
     */
    @Property(name="cellularExceptionAction")
    @JsonIgnore
    public Optional<VpnServiceExceptionAction> getCellularExceptionAction() {
        return Optional.ofNullable(cellularExceptionAction);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * cellularExceptionAction} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Determine whether Cellular service will be exempt from the always-on VPN
     * connection”</i>
     * 
     * @param cellularExceptionAction
     *            new value of {@code cellularExceptionAction} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cellularExceptionAction} field changed
     */
    public AppleVpnAlwaysOnConfiguration withCellularExceptionAction(VpnServiceExceptionAction cellularExceptionAction) {
        AppleVpnAlwaysOnConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appleVpnAlwaysOnConfiguration");
        _x.cellularExceptionAction = cellularExceptionAction;
        return _x;
    }

    /**
     * <i>“Specifies whether traffic from all captive network plugins should be allowed
     * outside the vpn”</i>
     * 
     * @return property allowAllCaptiveNetworkPlugins
     */
    @Property(name="allowAllCaptiveNetworkPlugins")
    @JsonIgnore
    public Optional<Boolean> getAllowAllCaptiveNetworkPlugins() {
        return Optional.ofNullable(allowAllCaptiveNetworkPlugins);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * allowAllCaptiveNetworkPlugins} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Specifies whether traffic from all captive network plugins should be allowed
     * outside the vpn”</i>
     * 
     * @param allowAllCaptiveNetworkPlugins
     *            new value of {@code allowAllCaptiveNetworkPlugins} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code allowAllCaptiveNetworkPlugins} field changed
     */
    public AppleVpnAlwaysOnConfiguration withAllowAllCaptiveNetworkPlugins(Boolean allowAllCaptiveNetworkPlugins) {
        AppleVpnAlwaysOnConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appleVpnAlwaysOnConfiguration");
        _x.allowAllCaptiveNetworkPlugins = allowAllCaptiveNetworkPlugins;
        return _x;
    }

    /**
     * <i>“Determines whether all, some, or no non-native captive networking apps are
     * allowed”</i>
     * 
     * @return property allowedCaptiveNetworkPlugins
     */
    @Property(name="allowedCaptiveNetworkPlugins")
    @JsonIgnore
    public Optional<SpecifiedCaptiveNetworkPlugins> getAllowedCaptiveNetworkPlugins() {
        return Optional.ofNullable(allowedCaptiveNetworkPlugins);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * allowedCaptiveNetworkPlugins} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Determines whether all, some, or no non-native captive networking apps are
     * allowed”</i>
     * 
     * @param allowedCaptiveNetworkPlugins
     *            new value of {@code allowedCaptiveNetworkPlugins} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code allowedCaptiveNetworkPlugins} field changed
     */
    public AppleVpnAlwaysOnConfiguration withAllowedCaptiveNetworkPlugins(SpecifiedCaptiveNetworkPlugins allowedCaptiveNetworkPlugins) {
        AppleVpnAlwaysOnConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appleVpnAlwaysOnConfiguration");
        _x.allowedCaptiveNetworkPlugins = allowedCaptiveNetworkPlugins;
        return _x;
    }

    /**
     * <i>“Determines whether traffic from the Websheet app is allowed outside of the VPN”</i>
     * 
     * @return property allowCaptiveWebSheet
     */
    @Property(name="allowCaptiveWebSheet")
    @JsonIgnore
    public Optional<Boolean> getAllowCaptiveWebSheet() {
        return Optional.ofNullable(allowCaptiveWebSheet);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * allowCaptiveWebSheet} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Determines whether traffic from the Websheet app is allowed outside of the VPN”</i>
     * 
     * @param allowCaptiveWebSheet
     *            new value of {@code allowCaptiveWebSheet} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code allowCaptiveWebSheet} field changed
     */
    public AppleVpnAlwaysOnConfiguration withAllowCaptiveWebSheet(Boolean allowCaptiveWebSheet) {
        AppleVpnAlwaysOnConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appleVpnAlwaysOnConfiguration");
        _x.allowCaptiveWebSheet = allowCaptiveWebSheet;
        return _x;
    }

    /**
     * <i>“Specifies how often in seconds to send a network address translation keepalive
     * package through the VPN”</i>
     * 
     * @return property natKeepAliveIntervalInSeconds
     */
    @Property(name="natKeepAliveIntervalInSeconds")
    @JsonIgnore
    public Optional<Integer> getNatKeepAliveIntervalInSeconds() {
        return Optional.ofNullable(natKeepAliveIntervalInSeconds);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * natKeepAliveIntervalInSeconds} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Specifies how often in seconds to send a network address translation keepalive
     * package through the VPN”</i>
     * 
     * @param natKeepAliveIntervalInSeconds
     *            new value of {@code natKeepAliveIntervalInSeconds} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code natKeepAliveIntervalInSeconds} field changed
     */
    public AppleVpnAlwaysOnConfiguration withNatKeepAliveIntervalInSeconds(Integer natKeepAliveIntervalInSeconds) {
        AppleVpnAlwaysOnConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appleVpnAlwaysOnConfiguration");
        _x.natKeepAliveIntervalInSeconds = natKeepAliveIntervalInSeconds;
        return _x;
    }

    /**
     * <i>“Enable hardware offloading of NAT keepalive signals when the device is asleep”</i>
     * 
     * @return property natKeepAliveOffloadEnable
     */
    @Property(name="natKeepAliveOffloadEnable")
    @JsonIgnore
    public Optional<Boolean> getNatKeepAliveOffloadEnable() {
        return Optional.ofNullable(natKeepAliveOffloadEnable);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * natKeepAliveOffloadEnable} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Enable hardware offloading of NAT keepalive signals when the device is asleep”</i>
     * 
     * @param natKeepAliveOffloadEnable
     *            new value of {@code natKeepAliveOffloadEnable} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code natKeepAliveOffloadEnable} field changed
     */
    public AppleVpnAlwaysOnConfiguration withNatKeepAliveOffloadEnable(Boolean natKeepAliveOffloadEnable) {
        AppleVpnAlwaysOnConfiguration _x = _copy();
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appleVpnAlwaysOnConfiguration");
        _x.natKeepAliveOffloadEnable = natKeepAliveOffloadEnable;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private VpnTunnelConfigurationType tunnelConfiguration;
        private Boolean userToggleEnabled;
        private VpnServiceExceptionAction voicemailExceptionAction;
        private VpnServiceExceptionAction airPrintExceptionAction;
        private VpnServiceExceptionAction cellularExceptionAction;
        private Boolean allowAllCaptiveNetworkPlugins;
        private SpecifiedCaptiveNetworkPlugins allowedCaptiveNetworkPlugins;
        private Boolean allowCaptiveWebSheet;
        private Integer natKeepAliveIntervalInSeconds;
        private Boolean natKeepAliveOffloadEnable;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        /**
         * <i>“Determines what connections the specific tunnel configuration applies to”</i>
         * 
         * @param tunnelConfiguration
         *            value of {@code tunnelConfiguration} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder tunnelConfiguration(VpnTunnelConfigurationType tunnelConfiguration) {
            this.tunnelConfiguration = tunnelConfiguration;
            this.changedFields = changedFields.add("tunnelConfiguration");
            return this;
        }

        /**
         * <i>“Allow the user to toggle the VPN configuration using the UI”</i>
         * 
         * @param userToggleEnabled
         *            value of {@code userToggleEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder userToggleEnabled(Boolean userToggleEnabled) {
            this.userToggleEnabled = userToggleEnabled;
            this.changedFields = changedFields.add("userToggleEnabled");
            return this;
        }

        /**
         * <i>“Determine whether voicemail service will be exempt from the always-on VPN
         * connection”</i>
         * 
         * @param voicemailExceptionAction
         *            value of {@code voicemailExceptionAction} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder voicemailExceptionAction(VpnServiceExceptionAction voicemailExceptionAction) {
            this.voicemailExceptionAction = voicemailExceptionAction;
            this.changedFields = changedFields.add("voicemailExceptionAction");
            return this;
        }

        /**
         * <i>“Determine whether AirPrint service will be exempt from the always-on VPN
         * connection”</i>
         * 
         * @param airPrintExceptionAction
         *            value of {@code airPrintExceptionAction} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder airPrintExceptionAction(VpnServiceExceptionAction airPrintExceptionAction) {
            this.airPrintExceptionAction = airPrintExceptionAction;
            this.changedFields = changedFields.add("airPrintExceptionAction");
            return this;
        }

        /**
         * <i>“Determine whether Cellular service will be exempt from the always-on VPN
         * connection”</i>
         * 
         * @param cellularExceptionAction
         *            value of {@code cellularExceptionAction} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cellularExceptionAction(VpnServiceExceptionAction cellularExceptionAction) {
            this.cellularExceptionAction = cellularExceptionAction;
            this.changedFields = changedFields.add("cellularExceptionAction");
            return this;
        }

        /**
         * <i>“Specifies whether traffic from all captive network plugins should be allowed
         * outside the vpn”</i>
         * 
         * @param allowAllCaptiveNetworkPlugins
         *            value of {@code allowAllCaptiveNetworkPlugins} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowAllCaptiveNetworkPlugins(Boolean allowAllCaptiveNetworkPlugins) {
            this.allowAllCaptiveNetworkPlugins = allowAllCaptiveNetworkPlugins;
            this.changedFields = changedFields.add("allowAllCaptiveNetworkPlugins");
            return this;
        }

        /**
         * <i>“Determines whether all, some, or no non-native captive networking apps are
         * allowed”</i>
         * 
         * @param allowedCaptiveNetworkPlugins
         *            value of {@code allowedCaptiveNetworkPlugins} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowedCaptiveNetworkPlugins(SpecifiedCaptiveNetworkPlugins allowedCaptiveNetworkPlugins) {
            this.allowedCaptiveNetworkPlugins = allowedCaptiveNetworkPlugins;
            this.changedFields = changedFields.add("allowedCaptiveNetworkPlugins");
            return this;
        }

        /**
         * <i>“Determines whether traffic from the Websheet app is allowed outside of the VPN”</i>
         * 
         * @param allowCaptiveWebSheet
         *            value of {@code allowCaptiveWebSheet} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowCaptiveWebSheet(Boolean allowCaptiveWebSheet) {
            this.allowCaptiveWebSheet = allowCaptiveWebSheet;
            this.changedFields = changedFields.add("allowCaptiveWebSheet");
            return this;
        }

        /**
         * <i>“Specifies how often in seconds to send a network address translation keepalive
         * package through the VPN”</i>
         * 
         * @param natKeepAliveIntervalInSeconds
         *            value of {@code natKeepAliveIntervalInSeconds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder natKeepAliveIntervalInSeconds(Integer natKeepAliveIntervalInSeconds) {
            this.natKeepAliveIntervalInSeconds = natKeepAliveIntervalInSeconds;
            this.changedFields = changedFields.add("natKeepAliveIntervalInSeconds");
            return this;
        }

        /**
         * <i>“Enable hardware offloading of NAT keepalive signals when the device is asleep”</i>
         * 
         * @param natKeepAliveOffloadEnable
         *            value of {@code natKeepAliveOffloadEnable} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder natKeepAliveOffloadEnable(Boolean natKeepAliveOffloadEnable) {
            this.natKeepAliveOffloadEnable = natKeepAliveOffloadEnable;
            this.changedFields = changedFields.add("natKeepAliveOffloadEnable");
            return this;
        }

        public AppleVpnAlwaysOnConfiguration build() {
            AppleVpnAlwaysOnConfiguration _x = new AppleVpnAlwaysOnConfiguration();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.appleVpnAlwaysOnConfiguration";
            _x.tunnelConfiguration = tunnelConfiguration;
            _x.userToggleEnabled = userToggleEnabled;
            _x.voicemailExceptionAction = voicemailExceptionAction;
            _x.airPrintExceptionAction = airPrintExceptionAction;
            _x.cellularExceptionAction = cellularExceptionAction;
            _x.allowAllCaptiveNetworkPlugins = allowAllCaptiveNetworkPlugins;
            _x.allowedCaptiveNetworkPlugins = allowedCaptiveNetworkPlugins;
            _x.allowCaptiveWebSheet = allowCaptiveWebSheet;
            _x.natKeepAliveIntervalInSeconds = natKeepAliveIntervalInSeconds;
            _x.natKeepAliveOffloadEnable = natKeepAliveOffloadEnable;
            return _x;
        }
    }

    private AppleVpnAlwaysOnConfiguration _copy() {
        AppleVpnAlwaysOnConfiguration _x = new AppleVpnAlwaysOnConfiguration();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.tunnelConfiguration = tunnelConfiguration;
        _x.userToggleEnabled = userToggleEnabled;
        _x.voicemailExceptionAction = voicemailExceptionAction;
        _x.airPrintExceptionAction = airPrintExceptionAction;
        _x.cellularExceptionAction = cellularExceptionAction;
        _x.allowAllCaptiveNetworkPlugins = allowAllCaptiveNetworkPlugins;
        _x.allowedCaptiveNetworkPlugins = allowedCaptiveNetworkPlugins;
        _x.allowCaptiveWebSheet = allowCaptiveWebSheet;
        _x.natKeepAliveIntervalInSeconds = natKeepAliveIntervalInSeconds;
        _x.natKeepAliveOffloadEnable = natKeepAliveOffloadEnable;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AppleVpnAlwaysOnConfiguration[");
        b.append("tunnelConfiguration=");
        b.append(this.tunnelConfiguration);
        b.append(", ");
        b.append("userToggleEnabled=");
        b.append(this.userToggleEnabled);
        b.append(", ");
        b.append("voicemailExceptionAction=");
        b.append(this.voicemailExceptionAction);
        b.append(", ");
        b.append("airPrintExceptionAction=");
        b.append(this.airPrintExceptionAction);
        b.append(", ");
        b.append("cellularExceptionAction=");
        b.append(this.cellularExceptionAction);
        b.append(", ");
        b.append("allowAllCaptiveNetworkPlugins=");
        b.append(this.allowAllCaptiveNetworkPlugins);
        b.append(", ");
        b.append("allowedCaptiveNetworkPlugins=");
        b.append(this.allowedCaptiveNetworkPlugins);
        b.append(", ");
        b.append("allowCaptiveWebSheet=");
        b.append(this.allowCaptiveWebSheet);
        b.append(", ");
        b.append("natKeepAliveIntervalInSeconds=");
        b.append(this.natKeepAliveIntervalInSeconds);
        b.append(", ");
        b.append("natKeepAliveOffloadEnable=");
        b.append(this.natKeepAliveOffloadEnable);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
